# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateDbConnectionBundleDetails(object):
    """
    The details for updating a database connection bundle.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateDbConnectionBundleDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateDbConnectionBundleDetails.
        :type display_name: str

        :param associated_resource_details:
            The value to assign to the associated_resource_details property of this UpdateDbConnectionBundleDetails.
        :type associated_resource_details: list[oci.database.models.AssociatedResourceDetails]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateDbConnectionBundleDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateDbConnectionBundleDetails.
        :type defined_tags: dict(str, dict(str, str))

        """
        self.swagger_types = {
            'display_name': 'str',
            'associated_resource_details': 'list[AssociatedResourceDetails]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, str))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'associated_resource_details': 'associatedResourceDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._associated_resource_details = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateDbConnectionBundleDetails.
        Display name for the connection bundle.


        :return: The display_name of this UpdateDbConnectionBundleDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateDbConnectionBundleDetails.
        Display name for the connection bundle.


        :param display_name: The display_name of this UpdateDbConnectionBundleDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def associated_resource_details(self):
        """
        Gets the associated_resource_details of this UpdateDbConnectionBundleDetails.
        Details about the resources to associate with the connection bundle.


        :return: The associated_resource_details of this UpdateDbConnectionBundleDetails.
        :rtype: list[oci.database.models.AssociatedResourceDetails]
        """
        return self._associated_resource_details

    @associated_resource_details.setter
    def associated_resource_details(self, associated_resource_details):
        """
        Sets the associated_resource_details of this UpdateDbConnectionBundleDetails.
        Details about the resources to associate with the connection bundle.


        :param associated_resource_details: The associated_resource_details of this UpdateDbConnectionBundleDetails.
        :type: list[oci.database.models.AssociatedResourceDetails]
        """
        self._associated_resource_details = associated_resource_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateDbConnectionBundleDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateDbConnectionBundleDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateDbConnectionBundleDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateDbConnectionBundleDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateDbConnectionBundleDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateDbConnectionBundleDetails.
        :rtype: dict(str, dict(str, str))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateDbConnectionBundleDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateDbConnectionBundleDetails.
        :type: dict(str, dict(str, str))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
