# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VanityUrlDetails(object):
    """
    Details for api gateway and vanity url(custom url) for dbTools.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VanityUrlDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_disabled:
            The value to assign to the is_disabled property of this VanityUrlDetails.
        :type is_disabled: bool

        :param api_gateway_id:
            The value to assign to the api_gateway_id property of this VanityUrlDetails.
        :type api_gateway_id: str

        :param vanity_url_host_name:
            The value to assign to the vanity_url_host_name property of this VanityUrlDetails.
        :type vanity_url_host_name: str

        """
        self.swagger_types = {
            'is_disabled': 'bool',
            'api_gateway_id': 'str',
            'vanity_url_host_name': 'str'
        }
        self.attribute_map = {
            'is_disabled': 'isDisabled',
            'api_gateway_id': 'apiGatewayId',
            'vanity_url_host_name': 'vanityUrlHostName'
        }
        self._is_disabled = None
        self._api_gateway_id = None
        self._vanity_url_host_name = None

    @property
    def is_disabled(self):
        """
        Gets the is_disabled of this VanityUrlDetails.
        Indicates if the vanity url details should be deleted for the Autonomous AI Database.


        :return: The is_disabled of this VanityUrlDetails.
        :rtype: bool
        """
        return self._is_disabled

    @is_disabled.setter
    def is_disabled(self, is_disabled):
        """
        Sets the is_disabled of this VanityUrlDetails.
        Indicates if the vanity url details should be deleted for the Autonomous AI Database.


        :param is_disabled: The is_disabled of this VanityUrlDetails.
        :type: bool
        """
        self._is_disabled = is_disabled

    @property
    def api_gateway_id(self):
        """
        Gets the api_gateway_id of this VanityUrlDetails.
        API Gateway ID.


        :return: The api_gateway_id of this VanityUrlDetails.
        :rtype: str
        """
        return self._api_gateway_id

    @api_gateway_id.setter
    def api_gateway_id(self, api_gateway_id):
        """
        Sets the api_gateway_id of this VanityUrlDetails.
        API Gateway ID.


        :param api_gateway_id: The api_gateway_id of this VanityUrlDetails.
        :type: str
        """
        self._api_gateway_id = api_gateway_id

    @property
    def vanity_url_host_name(self):
        """
        Gets the vanity_url_host_name of this VanityUrlDetails.
        Custom URL prefix provided by the customer to access dbTools.


        :return: The vanity_url_host_name of this VanityUrlDetails.
        :rtype: str
        """
        return self._vanity_url_host_name

    @vanity_url_host_name.setter
    def vanity_url_host_name(self, vanity_url_host_name):
        """
        Sets the vanity_url_host_name of this VanityUrlDetails.
        Custom URL prefix provided by the customer to access dbTools.


        :param vanity_url_host_name: The vanity_url_host_name of this VanityUrlDetails.
        :type: str
        """
        self._vanity_url_host_name = vanity_url_host_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
