# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101

from .cloud_db_system_connector import CloudDbSystemConnector
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CloudDbSystemMacsConnector(CloudDbSystemConnector):
    """
    The details of a cloud DB system connector that uses the
    `Management Agent Cloud Service (MACS)`__
    to connect to a cloud DB system component.

    __ https://docs.cloud.oracle.com/iaas/management-agents/index.html
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CloudDbSystemMacsConnector object with values from keyword arguments. The default value of the :py:attr:`~oci.database_management.models.CloudDbSystemMacsConnector.connector_type` attribute
        of this class is ``MACS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param connector_type:
            The value to assign to the connector_type property of this CloudDbSystemMacsConnector.
            Allowed values for this property are: "MACS"
        :type connector_type: str

        :param id:
            The value to assign to the id property of this CloudDbSystemMacsConnector.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this CloudDbSystemMacsConnector.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CloudDbSystemMacsConnector.
        :type compartment_id: str

        :param cloud_db_system_id:
            The value to assign to the cloud_db_system_id property of this CloudDbSystemMacsConnector.
        :type cloud_db_system_id: str

        :param connection_status:
            The value to assign to the connection_status property of this CloudDbSystemMacsConnector.
        :type connection_status: str

        :param connection_failure_message:
            The value to assign to the connection_failure_message property of this CloudDbSystemMacsConnector.
        :type connection_failure_message: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this CloudDbSystemMacsConnector.
            Allowed values for this property are: "CREATING", "NOT_CONNECTED", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this CloudDbSystemMacsConnector.
        :type lifecycle_details: str

        :param time_connection_status_last_updated:
            The value to assign to the time_connection_status_last_updated property of this CloudDbSystemMacsConnector.
        :type time_connection_status_last_updated: datetime

        :param time_created:
            The value to assign to the time_created property of this CloudDbSystemMacsConnector.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this CloudDbSystemMacsConnector.
        :type time_updated: datetime

        :param agent_id:
            The value to assign to the agent_id property of this CloudDbSystemMacsConnector.
        :type agent_id: str

        :param connection_info:
            The value to assign to the connection_info property of this CloudDbSystemMacsConnector.
        :type connection_info: oci.database_management.models.CloudDbSystemConnectionInfo

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CloudDbSystemMacsConnector.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CloudDbSystemMacsConnector.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this CloudDbSystemMacsConnector.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'connector_type': 'str',
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'cloud_db_system_id': 'str',
            'connection_status': 'str',
            'connection_failure_message': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_connection_status_last_updated': 'datetime',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'agent_id': 'str',
            'connection_info': 'CloudDbSystemConnectionInfo',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'connector_type': 'connectorType',
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'cloud_db_system_id': 'cloudDbSystemId',
            'connection_status': 'connectionStatus',
            'connection_failure_message': 'connectionFailureMessage',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_connection_status_last_updated': 'timeConnectionStatusLastUpdated',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'agent_id': 'agentId',
            'connection_info': 'connectionInfo',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._connector_type = None
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._cloud_db_system_id = None
        self._connection_status = None
        self._connection_failure_message = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_connection_status_last_updated = None
        self._time_created = None
        self._time_updated = None
        self._agent_id = None
        self._connection_info = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._connector_type = 'MACS'

    @property
    def agent_id(self):
        """
        **[Required]** Gets the agent_id of this CloudDbSystemMacsConnector.
        The `OCID`__ of the management agent
        used for the cloud DB system connector.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The agent_id of this CloudDbSystemMacsConnector.
        :rtype: str
        """
        return self._agent_id

    @agent_id.setter
    def agent_id(self, agent_id):
        """
        Sets the agent_id of this CloudDbSystemMacsConnector.
        The `OCID`__ of the management agent
        used for the cloud DB system connector.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param agent_id: The agent_id of this CloudDbSystemMacsConnector.
        :type: str
        """
        self._agent_id = agent_id

    @property
    def connection_info(self):
        """
        Gets the connection_info of this CloudDbSystemMacsConnector.

        :return: The connection_info of this CloudDbSystemMacsConnector.
        :rtype: oci.database_management.models.CloudDbSystemConnectionInfo
        """
        return self._connection_info

    @connection_info.setter
    def connection_info(self, connection_info):
        """
        Sets the connection_info of this CloudDbSystemMacsConnector.

        :param connection_info: The connection_info of this CloudDbSystemMacsConnector.
        :type: oci.database_management.models.CloudDbSystemConnectionInfo
        """
        self._connection_info = connection_info

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CloudDbSystemMacsConnector.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CloudDbSystemMacsConnector.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CloudDbSystemMacsConnector.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CloudDbSystemMacsConnector.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CloudDbSystemMacsConnector.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CloudDbSystemMacsConnector.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CloudDbSystemMacsConnector.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CloudDbSystemMacsConnector.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this CloudDbSystemMacsConnector.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this CloudDbSystemMacsConnector.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this CloudDbSystemMacsConnector.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this CloudDbSystemMacsConnector.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
