# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AdvisorCheckSummary(object):
    """
    Pre-Migration extended advisor report summary.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AdvisorCheckSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param pass_results_total_count:
            The value to assign to the pass_results_total_count property of this AdvisorCheckSummary.
        :type pass_results_total_count: int

        :param informational_results_total_count:
            The value to assign to the informational_results_total_count property of this AdvisorCheckSummary.
        :type informational_results_total_count: int

        :param warning_results_total_count:
            The value to assign to the warning_results_total_count property of this AdvisorCheckSummary.
        :type warning_results_total_count: int

        :param blocker_results_total_count:
            The value to assign to the blocker_results_total_count property of this AdvisorCheckSummary.
        :type blocker_results_total_count: int

        :param fatal_results_total_count:
            The value to assign to the fatal_results_total_count property of this AdvisorCheckSummary.
        :type fatal_results_total_count: int

        """
        self.swagger_types = {
            'pass_results_total_count': 'int',
            'informational_results_total_count': 'int',
            'warning_results_total_count': 'int',
            'blocker_results_total_count': 'int',
            'fatal_results_total_count': 'int'
        }
        self.attribute_map = {
            'pass_results_total_count': 'passResultsTotalCount',
            'informational_results_total_count': 'informationalResultsTotalCount',
            'warning_results_total_count': 'warningResultsTotalCount',
            'blocker_results_total_count': 'blockerResultsTotalCount',
            'fatal_results_total_count': 'fatalResultsTotalCount'
        }
        self._pass_results_total_count = None
        self._informational_results_total_count = None
        self._warning_results_total_count = None
        self._blocker_results_total_count = None
        self._fatal_results_total_count = None

    @property
    def pass_results_total_count(self):
        """
        **[Required]** Gets the pass_results_total_count of this AdvisorCheckSummary.
        Number of PASS results in the extended advisor report.


        :return: The pass_results_total_count of this AdvisorCheckSummary.
        :rtype: int
        """
        return self._pass_results_total_count

    @pass_results_total_count.setter
    def pass_results_total_count(self, pass_results_total_count):
        """
        Sets the pass_results_total_count of this AdvisorCheckSummary.
        Number of PASS results in the extended advisor report.


        :param pass_results_total_count: The pass_results_total_count of this AdvisorCheckSummary.
        :type: int
        """
        self._pass_results_total_count = pass_results_total_count

    @property
    def informational_results_total_count(self):
        """
        **[Required]** Gets the informational_results_total_count of this AdvisorCheckSummary.
        Number of INFORMATIONAL results in the extended advisor report.


        :return: The informational_results_total_count of this AdvisorCheckSummary.
        :rtype: int
        """
        return self._informational_results_total_count

    @informational_results_total_count.setter
    def informational_results_total_count(self, informational_results_total_count):
        """
        Sets the informational_results_total_count of this AdvisorCheckSummary.
        Number of INFORMATIONAL results in the extended advisor report.


        :param informational_results_total_count: The informational_results_total_count of this AdvisorCheckSummary.
        :type: int
        """
        self._informational_results_total_count = informational_results_total_count

    @property
    def warning_results_total_count(self):
        """
        **[Required]** Gets the warning_results_total_count of this AdvisorCheckSummary.
        Number of WARNING results in the extended advisor report.


        :return: The warning_results_total_count of this AdvisorCheckSummary.
        :rtype: int
        """
        return self._warning_results_total_count

    @warning_results_total_count.setter
    def warning_results_total_count(self, warning_results_total_count):
        """
        Sets the warning_results_total_count of this AdvisorCheckSummary.
        Number of WARNING results in the extended advisor report.


        :param warning_results_total_count: The warning_results_total_count of this AdvisorCheckSummary.
        :type: int
        """
        self._warning_results_total_count = warning_results_total_count

    @property
    def blocker_results_total_count(self):
        """
        **[Required]** Gets the blocker_results_total_count of this AdvisorCheckSummary.
        Number of BLOCKER results in the extended advisor report.


        :return: The blocker_results_total_count of this AdvisorCheckSummary.
        :rtype: int
        """
        return self._blocker_results_total_count

    @blocker_results_total_count.setter
    def blocker_results_total_count(self, blocker_results_total_count):
        """
        Sets the blocker_results_total_count of this AdvisorCheckSummary.
        Number of BLOCKER results in the extended advisor report.


        :param blocker_results_total_count: The blocker_results_total_count of this AdvisorCheckSummary.
        :type: int
        """
        self._blocker_results_total_count = blocker_results_total_count

    @property
    def fatal_results_total_count(self):
        """
        **[Required]** Gets the fatal_results_total_count of this AdvisorCheckSummary.
        Number of FATAL results in the extended advisor report.


        :return: The fatal_results_total_count of this AdvisorCheckSummary.
        :rtype: int
        """
        return self._fatal_results_total_count

    @fatal_results_total_count.setter
    def fatal_results_total_count(self, fatal_results_total_count):
        """
        Sets the fatal_results_total_count of this AdvisorCheckSummary.
        Number of FATAL results in the extended advisor report.


        :param fatal_results_total_count: The fatal_results_total_count of this AdvisorCheckSummary.
        :type: int
        """
        self._fatal_results_total_count = fatal_results_total_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
