# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AdvisorReportCheckCollection(object):
    """
    Pre-Migration extended advisor report result.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AdvisorReportCheckCollection object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param summary:
            The value to assign to the summary property of this AdvisorReportCheckCollection.
        :type summary: oci.database_migration.models.AdvisorCheckSummary

        :param items:
            The value to assign to the items property of this AdvisorReportCheckCollection.
        :type items: list[oci.database_migration.models.AdvisorReportCheckSummary]

        """
        self.swagger_types = {
            'summary': 'AdvisorCheckSummary',
            'items': 'list[AdvisorReportCheckSummary]'
        }
        self.attribute_map = {
            'summary': 'summary',
            'items': 'items'
        }
        self._summary = None
        self._items = None

    @property
    def summary(self):
        """
        **[Required]** Gets the summary of this AdvisorReportCheckCollection.

        :return: The summary of this AdvisorReportCheckCollection.
        :rtype: oci.database_migration.models.AdvisorCheckSummary
        """
        return self._summary

    @summary.setter
    def summary(self, summary):
        """
        Sets the summary of this AdvisorReportCheckCollection.

        :param summary: The summary of this AdvisorReportCheckCollection.
        :type: oci.database_migration.models.AdvisorCheckSummary
        """
        self._summary = summary

    @property
    def items(self):
        """
        **[Required]** Gets the items of this AdvisorReportCheckCollection.
        Array of advisor check items.


        :return: The items of this AdvisorReportCheckCollection.
        :rtype: list[oci.database_migration.models.AdvisorReportCheckSummary]
        """
        return self._items

    @items.setter
    def items(self, items):
        """
        Sets the items of this AdvisorReportCheckCollection.
        Array of advisor check items.


        :param items: The items of this AdvisorReportCheckCollection.
        :type: list[oci.database_migration.models.AdvisorReportCheckSummary]
        """
        self._items = items

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
