# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AdvisorReportCheckObjectSummary(object):
    """
    Database objects to migration.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AdvisorReportCheckObjectSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param fields:
            The value to assign to the fields property of this AdvisorReportCheckObjectSummary.
        :type fields: dict(str, str)

        :param is_excluded:
            The value to assign to the is_excluded property of this AdvisorReportCheckObjectSummary.
        :type is_excluded: bool

        :param freeform_tags:
            The value to assign to the freeform_tags property of this AdvisorReportCheckObjectSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this AdvisorReportCheckObjectSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this AdvisorReportCheckObjectSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'fields': 'dict(str, str)',
            'is_excluded': 'bool',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'fields': 'fields',
            'is_excluded': 'isExcluded',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._fields = None
        self._is_excluded = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def fields(self):
        """
        **[Required]** Gets the fields of this AdvisorReportCheckObjectSummary.

        :return: The fields of this AdvisorReportCheckObjectSummary.
        :rtype: dict(str, str)
        """
        return self._fields

    @fields.setter
    def fields(self, fields):
        """
        Sets the fields of this AdvisorReportCheckObjectSummary.

        :param fields: The fields of this AdvisorReportCheckObjectSummary.
        :type: dict(str, str)
        """
        self._fields = fields

    @property
    def is_excluded(self):
        """
        **[Required]** Gets the is_excluded of this AdvisorReportCheckObjectSummary.
        If the object was excluded from migration, then it is true.


        :return: The is_excluded of this AdvisorReportCheckObjectSummary.
        :rtype: bool
        """
        return self._is_excluded

    @is_excluded.setter
    def is_excluded(self, is_excluded):
        """
        Sets the is_excluded of this AdvisorReportCheckObjectSummary.
        If the object was excluded from migration, then it is true.


        :param is_excluded: The is_excluded of this AdvisorReportCheckObjectSummary.
        :type: bool
        """
        self._is_excluded = is_excluded

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this AdvisorReportCheckObjectSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see Resource Tags. Example: {\"Department\": \"Finance\"}


        :return: The freeform_tags of this AdvisorReportCheckObjectSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this AdvisorReportCheckObjectSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see Resource Tags. Example: {\"Department\": \"Finance\"}


        :param freeform_tags: The freeform_tags of this AdvisorReportCheckObjectSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this AdvisorReportCheckObjectSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this AdvisorReportCheckObjectSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this AdvisorReportCheckObjectSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this AdvisorReportCheckObjectSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this AdvisorReportCheckObjectSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this AdvisorReportCheckObjectSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this AdvisorReportCheckObjectSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this AdvisorReportCheckObjectSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
