# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AdvisorReportCheckSummary(object):
    """
    Pre-Migration extended advisor report check item.
    """

    #: A constant which can be used with the result_type property of a AdvisorReportCheckSummary.
    #: This constant has a value of "FATAL"
    RESULT_TYPE_FATAL = "FATAL"

    #: A constant which can be used with the result_type property of a AdvisorReportCheckSummary.
    #: This constant has a value of "BLOCKER"
    RESULT_TYPE_BLOCKER = "BLOCKER"

    #: A constant which can be used with the result_type property of a AdvisorReportCheckSummary.
    #: This constant has a value of "WARNING"
    RESULT_TYPE_WARNING = "WARNING"

    #: A constant which can be used with the result_type property of a AdvisorReportCheckSummary.
    #: This constant has a value of "INFORMATIONAL"
    RESULT_TYPE_INFORMATIONAL = "INFORMATIONAL"

    #: A constant which can be used with the result_type property of a AdvisorReportCheckSummary.
    #: This constant has a value of "PASS"
    RESULT_TYPE_PASS = "PASS"

    def __init__(self, **kwargs):
        """
        Initializes a new AdvisorReportCheckSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key:
            The value to assign to the key property of this AdvisorReportCheckSummary.
        :type key: str

        :param display_name:
            The value to assign to the display_name property of this AdvisorReportCheckSummary.
        :type display_name: str

        :param result_type:
            The value to assign to the result_type property of this AdvisorReportCheckSummary.
            Allowed values for this property are: "FATAL", "BLOCKER", "WARNING", "INFORMATIONAL", "PASS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type result_type: str

        :param is_reviewed:
            The value to assign to the is_reviewed property of this AdvisorReportCheckSummary.
        :type is_reviewed: bool

        :param issue:
            The value to assign to the issue property of this AdvisorReportCheckSummary.
        :type issue: str

        :param impact:
            The value to assign to the impact property of this AdvisorReportCheckSummary.
        :type impact: str

        :param action:
            The value to assign to the action property of this AdvisorReportCheckSummary.
        :type action: str

        :param fixup_script_location:
            The value to assign to the fixup_script_location property of this AdvisorReportCheckSummary.
        :type fixup_script_location: str

        :param is_exclusion_allowed:
            The value to assign to the is_exclusion_allowed property of this AdvisorReportCheckSummary.
        :type is_exclusion_allowed: bool

        :param metadata:
            The value to assign to the metadata property of this AdvisorReportCheckSummary.
        :type metadata: oci.database_migration.models.ObjectMetadata

        :param columns:
            The value to assign to the columns property of this AdvisorReportCheckSummary.
        :type columns: list[oci.database_migration.models.AdvisorReportCheckColumn]

        :param object_count:
            The value to assign to the object_count property of this AdvisorReportCheckSummary.
        :type object_count: int

        """
        self.swagger_types = {
            'key': 'str',
            'display_name': 'str',
            'result_type': 'str',
            'is_reviewed': 'bool',
            'issue': 'str',
            'impact': 'str',
            'action': 'str',
            'fixup_script_location': 'str',
            'is_exclusion_allowed': 'bool',
            'metadata': 'ObjectMetadata',
            'columns': 'list[AdvisorReportCheckColumn]',
            'object_count': 'int'
        }
        self.attribute_map = {
            'key': 'key',
            'display_name': 'displayName',
            'result_type': 'resultType',
            'is_reviewed': 'isReviewed',
            'issue': 'issue',
            'impact': 'impact',
            'action': 'action',
            'fixup_script_location': 'fixupScriptLocation',
            'is_exclusion_allowed': 'isExclusionAllowed',
            'metadata': 'metadata',
            'columns': 'columns',
            'object_count': 'objectCount'
        }
        self._key = None
        self._display_name = None
        self._result_type = None
        self._is_reviewed = None
        self._issue = None
        self._impact = None
        self._action = None
        self._fixup_script_location = None
        self._is_exclusion_allowed = None
        self._metadata = None
        self._columns = None
        self._object_count = None

    @property
    def key(self):
        """
        **[Required]** Gets the key of this AdvisorReportCheckSummary.
        Pre-Migration \u0441heck id.


        :return: The key of this AdvisorReportCheckSummary.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this AdvisorReportCheckSummary.
        Pre-Migration \u0441heck id.


        :param key: The key of this AdvisorReportCheckSummary.
        :type: str
        """
        self._key = key

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this AdvisorReportCheckSummary.
        Pre-Migration \u0441heck display name.


        :return: The display_name of this AdvisorReportCheckSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AdvisorReportCheckSummary.
        Pre-Migration \u0441heck display name.


        :param display_name: The display_name of this AdvisorReportCheckSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def result_type(self):
        """
        **[Required]** Gets the result_type of this AdvisorReportCheckSummary.
        Pre-Migration advisor result.

        Allowed values for this property are: "FATAL", "BLOCKER", "WARNING", "INFORMATIONAL", "PASS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The result_type of this AdvisorReportCheckSummary.
        :rtype: str
        """
        return self._result_type

    @result_type.setter
    def result_type(self, result_type):
        """
        Sets the result_type of this AdvisorReportCheckSummary.
        Pre-Migration advisor result.


        :param result_type: The result_type of this AdvisorReportCheckSummary.
        :type: str
        """
        allowed_values = ["FATAL", "BLOCKER", "WARNING", "INFORMATIONAL", "PASS"]
        if not value_allowed_none_or_none_sentinel(result_type, allowed_values):
            result_type = 'UNKNOWN_ENUM_VALUE'
        self._result_type = result_type

    @property
    def is_reviewed(self):
        """
        **[Required]** Gets the is_reviewed of this AdvisorReportCheckSummary.
        User flag for advisor report check.


        :return: The is_reviewed of this AdvisorReportCheckSummary.
        :rtype: bool
        """
        return self._is_reviewed

    @is_reviewed.setter
    def is_reviewed(self, is_reviewed):
        """
        Sets the is_reviewed of this AdvisorReportCheckSummary.
        User flag for advisor report check.


        :param is_reviewed: The is_reviewed of this AdvisorReportCheckSummary.
        :type: bool
        """
        self._is_reviewed = is_reviewed

    @property
    def issue(self):
        """
        **[Required]** Gets the issue of this AdvisorReportCheckSummary.
        Description of the issue.


        :return: The issue of this AdvisorReportCheckSummary.
        :rtype: str
        """
        return self._issue

    @issue.setter
    def issue(self, issue):
        """
        Sets the issue of this AdvisorReportCheckSummary.
        Description of the issue.


        :param issue: The issue of this AdvisorReportCheckSummary.
        :type: str
        """
        self._issue = issue

    @property
    def impact(self):
        """
        **[Required]** Gets the impact of this AdvisorReportCheckSummary.
        Impact of the issue on data migration.


        :return: The impact of this AdvisorReportCheckSummary.
        :rtype: str
        """
        return self._impact

    @impact.setter
    def impact(self, impact):
        """
        Sets the impact of this AdvisorReportCheckSummary.
        Impact of the issue on data migration.


        :param impact: The impact of this AdvisorReportCheckSummary.
        :type: str
        """
        self._impact = impact

    @property
    def action(self):
        """
        **[Required]** Gets the action of this AdvisorReportCheckSummary.
        Fixing the issue.


        :return: The action of this AdvisorReportCheckSummary.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this AdvisorReportCheckSummary.
        Fixing the issue.


        :param action: The action of this AdvisorReportCheckSummary.
        :type: str
        """
        self._action = action

    @property
    def fixup_script_location(self):
        """
        Gets the fixup_script_location of this AdvisorReportCheckSummary.
        The path to the fixup script for this check.


        :return: The fixup_script_location of this AdvisorReportCheckSummary.
        :rtype: str
        """
        return self._fixup_script_location

    @fixup_script_location.setter
    def fixup_script_location(self, fixup_script_location):
        """
        Sets the fixup_script_location of this AdvisorReportCheckSummary.
        The path to the fixup script for this check.


        :param fixup_script_location: The fixup_script_location of this AdvisorReportCheckSummary.
        :type: str
        """
        self._fixup_script_location = fixup_script_location

    @property
    def is_exclusion_allowed(self):
        """
        **[Required]** Gets the is_exclusion_allowed of this AdvisorReportCheckSummary.
        If false, objects cannot be excluded from migration.


        :return: The is_exclusion_allowed of this AdvisorReportCheckSummary.
        :rtype: bool
        """
        return self._is_exclusion_allowed

    @is_exclusion_allowed.setter
    def is_exclusion_allowed(self, is_exclusion_allowed):
        """
        Sets the is_exclusion_allowed of this AdvisorReportCheckSummary.
        If false, objects cannot be excluded from migration.


        :param is_exclusion_allowed: The is_exclusion_allowed of this AdvisorReportCheckSummary.
        :type: bool
        """
        self._is_exclusion_allowed = is_exclusion_allowed

    @property
    def metadata(self):
        """
        Gets the metadata of this AdvisorReportCheckSummary.

        :return: The metadata of this AdvisorReportCheckSummary.
        :rtype: oci.database_migration.models.ObjectMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this AdvisorReportCheckSummary.

        :param metadata: The metadata of this AdvisorReportCheckSummary.
        :type: oci.database_migration.models.ObjectMetadata
        """
        self._metadata = metadata

    @property
    def columns(self):
        """
        **[Required]** Gets the columns of this AdvisorReportCheckSummary.
        Array of the column of the objects table.


        :return: The columns of this AdvisorReportCheckSummary.
        :rtype: list[oci.database_migration.models.AdvisorReportCheckColumn]
        """
        return self._columns

    @columns.setter
    def columns(self, columns):
        """
        Sets the columns of this AdvisorReportCheckSummary.
        Array of the column of the objects table.


        :param columns: The columns of this AdvisorReportCheckSummary.
        :type: list[oci.database_migration.models.AdvisorReportCheckColumn]
        """
        self._columns = columns

    @property
    def object_count(self):
        """
        **[Required]** Gets the object_count of this AdvisorReportCheckSummary.
        Number of database objects to migrate.


        :return: The object_count of this AdvisorReportCheckSummary.
        :rtype: int
        """
        return self._object_count

    @object_count.setter
    def object_count(self, object_count):
        """
        Sets the object_count of this AdvisorReportCheckSummary.
        Number of database objects to migrate.


        :param object_count: The object_count of this AdvisorReportCheckSummary.
        :type: int
        """
        self._object_count = object_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
