# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Assessment(object):
    """
    Assessment resource
    """

    #: A constant which can be used with the database_combination property of a Assessment.
    #: This constant has a value of "MYSQL"
    DATABASE_COMBINATION_MYSQL = "MYSQL"

    #: A constant which can be used with the database_combination property of a Assessment.
    #: This constant has a value of "ORACLE"
    DATABASE_COMBINATION_ORACLE = "ORACLE"

    #: A constant which can be used with the network_speed_megabit_per_second property of a Assessment.
    #: This constant has a value of "MBPS_10"
    NETWORK_SPEED_MEGABIT_PER_SECOND_MBPS_10 = "MBPS_10"

    #: A constant which can be used with the network_speed_megabit_per_second property of a Assessment.
    #: This constant has a value of "MBPS_100"
    NETWORK_SPEED_MEGABIT_PER_SECOND_MBPS_100 = "MBPS_100"

    #: A constant which can be used with the network_speed_megabit_per_second property of a Assessment.
    #: This constant has a value of "MBPS_1000"
    NETWORK_SPEED_MEGABIT_PER_SECOND_MBPS_1000 = "MBPS_1000"

    #: A constant which can be used with the network_speed_megabit_per_second property of a Assessment.
    #: This constant has a value of "MBPS_2500"
    NETWORK_SPEED_MEGABIT_PER_SECOND_MBPS_2500 = "MBPS_2500"

    #: A constant which can be used with the network_speed_megabit_per_second property of a Assessment.
    #: This constant has a value of "MBPS_5000"
    NETWORK_SPEED_MEGABIT_PER_SECOND_MBPS_5000 = "MBPS_5000"

    #: A constant which can be used with the network_speed_megabit_per_second property of a Assessment.
    #: This constant has a value of "MBPS_10000"
    NETWORK_SPEED_MEGABIT_PER_SECOND_MBPS_10000 = "MBPS_10000"

    #: A constant which can be used with the acceptable_downtime property of a Assessment.
    #: This constant has a value of "LESS_THAN_10_MINUTES"
    ACCEPTABLE_DOWNTIME_LESS_THAN_10_MINUTES = "LESS_THAN_10_MINUTES"

    #: A constant which can be used with the acceptable_downtime property of a Assessment.
    #: This constant has a value of "LESS_THAN_1_HOUR"
    ACCEPTABLE_DOWNTIME_LESS_THAN_1_HOUR = "LESS_THAN_1_HOUR"

    #: A constant which can be used with the acceptable_downtime property of a Assessment.
    #: This constant has a value of "LESS_THAN_4_HOURS"
    ACCEPTABLE_DOWNTIME_LESS_THAN_4_HOURS = "LESS_THAN_4_HOURS"

    #: A constant which can be used with the acceptable_downtime property of a Assessment.
    #: This constant has a value of "LESS_THAN_8_HOURS"
    ACCEPTABLE_DOWNTIME_LESS_THAN_8_HOURS = "LESS_THAN_8_HOURS"

    #: A constant which can be used with the acceptable_downtime property of a Assessment.
    #: This constant has a value of "LESS_THAN_12_HOURS"
    ACCEPTABLE_DOWNTIME_LESS_THAN_12_HOURS = "LESS_THAN_12_HOURS"

    #: A constant which can be used with the acceptable_downtime property of a Assessment.
    #: This constant has a value of "LESS_THAN_1_DAY"
    ACCEPTABLE_DOWNTIME_LESS_THAN_1_DAY = "LESS_THAN_1_DAY"

    #: A constant which can be used with the acceptable_downtime property of a Assessment.
    #: This constant has a value of "LESS_THAN_2_DAYS"
    ACCEPTABLE_DOWNTIME_LESS_THAN_2_DAYS = "LESS_THAN_2_DAYS"

    #: A constant which can be used with the acceptable_downtime property of a Assessment.
    #: This constant has a value of "MORE_THAN_2_DAYS"
    ACCEPTABLE_DOWNTIME_MORE_THAN_2_DAYS = "MORE_THAN_2_DAYS"

    #: A constant which can be used with the database_data_size property of a Assessment.
    #: This constant has a value of "LESS_THAN_1GB"
    DATABASE_DATA_SIZE_LESS_THAN_1_GB = "LESS_THAN_1GB"

    #: A constant which can be used with the database_data_size property of a Assessment.
    #: This constant has a value of "GB_1_10"
    DATABASE_DATA_SIZE_GB_1_10 = "GB_1_10"

    #: A constant which can be used with the database_data_size property of a Assessment.
    #: This constant has a value of "GB_10_50"
    DATABASE_DATA_SIZE_GB_10_50 = "GB_10_50"

    #: A constant which can be used with the database_data_size property of a Assessment.
    #: This constant has a value of "GB_50_100"
    DATABASE_DATA_SIZE_GB_50_100 = "GB_50_100"

    #: A constant which can be used with the database_data_size property of a Assessment.
    #: This constant has a value of "GB_100_500"
    DATABASE_DATA_SIZE_GB_100_500 = "GB_100_500"

    #: A constant which can be used with the database_data_size property of a Assessment.
    #: This constant has a value of "GB_500_TB_1"
    DATABASE_DATA_SIZE_GB_500_TB_1 = "GB_500_TB_1"

    #: A constant which can be used with the database_data_size property of a Assessment.
    #: This constant has a value of "TB_1_3"
    DATABASE_DATA_SIZE_TB_1_3 = "TB_1_3"

    #: A constant which can be used with the database_data_size property of a Assessment.
    #: This constant has a value of "TB_3_10"
    DATABASE_DATA_SIZE_TB_3_10 = "TB_3_10"

    #: A constant which can be used with the database_data_size property of a Assessment.
    #: This constant has a value of "TB_10_50"
    DATABASE_DATA_SIZE_TB_10_50 = "TB_10_50"

    #: A constant which can be used with the database_data_size property of a Assessment.
    #: This constant has a value of "GREATER_THAN_50TB"
    DATABASE_DATA_SIZE_GREATER_THAN_50_TB = "GREATER_THAN_50TB"

    #: A constant which can be used with the ddl_expectation property of a Assessment.
    #: This constant has a value of "DDL_EXPECTED"
    DDL_EXPECTATION_DDL_EXPECTED = "DDL_EXPECTED"

    #: A constant which can be used with the ddl_expectation property of a Assessment.
    #: This constant has a value of "DDL_NOT_EXPECTED"
    DDL_EXPECTATION_DDL_NOT_EXPECTED = "DDL_NOT_EXPECTED"

    #: A constant which can be used with the creation_type property of a Assessment.
    #: This constant has a value of "CREATE_ONLY"
    CREATION_TYPE_CREATE_ONLY = "CREATE_ONLY"

    #: A constant which can be used with the creation_type property of a Assessment.
    #: This constant has a value of "CREATE_AND_RUN_ASSESSORS"
    CREATION_TYPE_CREATE_AND_RUN_ASSESSORS = "CREATE_AND_RUN_ASSESSORS"

    #: A constant which can be used with the lifecycle_state property of a Assessment.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a Assessment.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a Assessment.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a Assessment.
    #: This constant has a value of "SUCCEEDED"
    LIFECYCLE_STATE_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the lifecycle_state property of a Assessment.
    #: This constant has a value of "IN_PROGRESS"
    LIFECYCLE_STATE_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the lifecycle_state property of a Assessment.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the lifecycle_state property of a Assessment.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a Assessment.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a Assessment.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the assessment_migration_type property of a Assessment.
    #: This constant has a value of "ONLINE"
    ASSESSMENT_MIGRATION_TYPE_ONLINE = "ONLINE"

    #: A constant which can be used with the assessment_migration_type property of a Assessment.
    #: This constant has a value of "ONLINE_STANDBY"
    ASSESSMENT_MIGRATION_TYPE_ONLINE_STANDBY = "ONLINE_STANDBY"

    #: A constant which can be used with the assessment_migration_type property of a Assessment.
    #: This constant has a value of "OFFLINE"
    ASSESSMENT_MIGRATION_TYPE_OFFLINE = "OFFLINE"

    def __init__(self, **kwargs):
        """
        Initializes a new Assessment object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.database_migration.models.MySqlAssessment`
        * :class:`~oci.database_migration.models.OracleAssessment`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Assessment.
        :type id: str

        :param description:
            The value to assign to the description property of this Assessment.
        :type description: str

        :param database_combination:
            The value to assign to the database_combination property of this Assessment.
            Allowed values for this property are: "MYSQL", "ORACLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type database_combination: str

        :param display_name:
            The value to assign to the display_name property of this Assessment.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this Assessment.
        :type compartment_id: str

        :param network_speed_megabit_per_second:
            The value to assign to the network_speed_megabit_per_second property of this Assessment.
            Allowed values for this property are: "MBPS_10", "MBPS_100", "MBPS_1000", "MBPS_2500", "MBPS_5000", "MBPS_10000", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type network_speed_megabit_per_second: str

        :param acceptable_downtime:
            The value to assign to the acceptable_downtime property of this Assessment.
            Allowed values for this property are: "LESS_THAN_10_MINUTES", "LESS_THAN_1_HOUR", "LESS_THAN_4_HOURS", "LESS_THAN_8_HOURS", "LESS_THAN_12_HOURS", "LESS_THAN_1_DAY", "LESS_THAN_2_DAYS", "MORE_THAN_2_DAYS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type acceptable_downtime: str

        :param database_data_size:
            The value to assign to the database_data_size property of this Assessment.
            Allowed values for this property are: "LESS_THAN_1GB", "GB_1_10", "GB_10_50", "GB_50_100", "GB_100_500", "GB_500_TB_1", "TB_1_3", "TB_3_10", "TB_10_50", "GREATER_THAN_50TB", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type database_data_size: str

        :param ddl_expectation:
            The value to assign to the ddl_expectation property of this Assessment.
            Allowed values for this property are: "DDL_EXPECTED", "DDL_NOT_EXPECTED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type ddl_expectation: str

        :param creation_type:
            The value to assign to the creation_type property of this Assessment.
            Allowed values for this property are: "CREATE_ONLY", "CREATE_AND_RUN_ASSESSORS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type creation_type: str

        :param migration_id:
            The value to assign to the migration_id property of this Assessment.
        :type migration_id: str

        :param source_database_connection:
            The value to assign to the source_database_connection property of this Assessment.
        :type source_database_connection: oci.database_migration.models.SourceAssessmentConnection

        :param target_database_connection:
            The value to assign to the target_database_connection property of this Assessment.
        :type target_database_connection: oci.database_migration.models.TargetAssessmentConnection

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this Assessment.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "SUCCEEDED", "IN_PROGRESS", "NEEDS_ATTENTION", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param assessment_migration_type:
            The value to assign to the assessment_migration_type property of this Assessment.
            Allowed values for this property are: "ONLINE", "ONLINE_STANDBY", "OFFLINE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type assessment_migration_type: str

        :param time_created:
            The value to assign to the time_created property of this Assessment.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this Assessment.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this Assessment.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this Assessment.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this Assessment.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'description': 'str',
            'database_combination': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'network_speed_megabit_per_second': 'str',
            'acceptable_downtime': 'str',
            'database_data_size': 'str',
            'ddl_expectation': 'str',
            'creation_type': 'str',
            'migration_id': 'str',
            'source_database_connection': 'SourceAssessmentConnection',
            'target_database_connection': 'TargetAssessmentConnection',
            'lifecycle_state': 'str',
            'assessment_migration_type': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'description': 'description',
            'database_combination': 'databaseCombination',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'network_speed_megabit_per_second': 'networkSpeedMegabitPerSecond',
            'acceptable_downtime': 'acceptableDowntime',
            'database_data_size': 'databaseDataSize',
            'ddl_expectation': 'ddlExpectation',
            'creation_type': 'creationType',
            'migration_id': 'migrationId',
            'source_database_connection': 'sourceDatabaseConnection',
            'target_database_connection': 'targetDatabaseConnection',
            'lifecycle_state': 'lifecycleState',
            'assessment_migration_type': 'assessmentMigrationType',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._description = None
        self._database_combination = None
        self._display_name = None
        self._compartment_id = None
        self._network_speed_megabit_per_second = None
        self._acceptable_downtime = None
        self._database_data_size = None
        self._ddl_expectation = None
        self._creation_type = None
        self._migration_id = None
        self._source_database_connection = None
        self._target_database_connection = None
        self._lifecycle_state = None
        self._assessment_migration_type = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['databaseCombination']

        if type == 'MYSQL':
            return 'MySqlAssessment'

        if type == 'ORACLE':
            return 'OracleAssessment'
        else:
            return 'Assessment'

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Assessment.
        The OCID of the resource being referenced.


        :return: The id of this Assessment.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Assessment.
        The OCID of the resource being referenced.


        :param id: The id of this Assessment.
        :type: str
        """
        self._id = id

    @property
    def description(self):
        """
        Gets the description of this Assessment.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The description of this Assessment.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Assessment.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param description: The description of this Assessment.
        :type: str
        """
        self._description = description

    @property
    def database_combination(self):
        """
        **[Required]** Gets the database_combination of this Assessment.
        The combination of source and target databases participating in a migration.
        Example: ORACLE means the migration is meant for migrating Oracle source and target databases.

        Allowed values for this property are: "MYSQL", "ORACLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The database_combination of this Assessment.
        :rtype: str
        """
        return self._database_combination

    @database_combination.setter
    def database_combination(self, database_combination):
        """
        Sets the database_combination of this Assessment.
        The combination of source and target databases participating in a migration.
        Example: ORACLE means the migration is meant for migrating Oracle source and target databases.


        :param database_combination: The database_combination of this Assessment.
        :type: str
        """
        allowed_values = ["MYSQL", "ORACLE"]
        if not value_allowed_none_or_none_sentinel(database_combination, allowed_values):
            database_combination = 'UNKNOWN_ENUM_VALUE'
        self._database_combination = database_combination

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this Assessment.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this Assessment.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Assessment.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this Assessment.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this Assessment.
        The OCID of the resource being referenced.


        :return: The compartment_id of this Assessment.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this Assessment.
        The OCID of the resource being referenced.


        :param compartment_id: The compartment_id of this Assessment.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def network_speed_megabit_per_second(self):
        """
        **[Required]** Gets the network_speed_megabit_per_second of this Assessment.
        A network speed in Megabits per second.

        Allowed values for this property are: "MBPS_10", "MBPS_100", "MBPS_1000", "MBPS_2500", "MBPS_5000", "MBPS_10000", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The network_speed_megabit_per_second of this Assessment.
        :rtype: str
        """
        return self._network_speed_megabit_per_second

    @network_speed_megabit_per_second.setter
    def network_speed_megabit_per_second(self, network_speed_megabit_per_second):
        """
        Sets the network_speed_megabit_per_second of this Assessment.
        A network speed in Megabits per second.


        :param network_speed_megabit_per_second: The network_speed_megabit_per_second of this Assessment.
        :type: str
        """
        allowed_values = ["MBPS_10", "MBPS_100", "MBPS_1000", "MBPS_2500", "MBPS_5000", "MBPS_10000"]
        if not value_allowed_none_or_none_sentinel(network_speed_megabit_per_second, allowed_values):
            network_speed_megabit_per_second = 'UNKNOWN_ENUM_VALUE'
        self._network_speed_megabit_per_second = network_speed_megabit_per_second

    @property
    def acceptable_downtime(self):
        """
        **[Required]** Gets the acceptable_downtime of this Assessment.
        Time allowed for the application downtime.

        Allowed values for this property are: "LESS_THAN_10_MINUTES", "LESS_THAN_1_HOUR", "LESS_THAN_4_HOURS", "LESS_THAN_8_HOURS", "LESS_THAN_12_HOURS", "LESS_THAN_1_DAY", "LESS_THAN_2_DAYS", "MORE_THAN_2_DAYS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The acceptable_downtime of this Assessment.
        :rtype: str
        """
        return self._acceptable_downtime

    @acceptable_downtime.setter
    def acceptable_downtime(self, acceptable_downtime):
        """
        Sets the acceptable_downtime of this Assessment.
        Time allowed for the application downtime.


        :param acceptable_downtime: The acceptable_downtime of this Assessment.
        :type: str
        """
        allowed_values = ["LESS_THAN_10_MINUTES", "LESS_THAN_1_HOUR", "LESS_THAN_4_HOURS", "LESS_THAN_8_HOURS", "LESS_THAN_12_HOURS", "LESS_THAN_1_DAY", "LESS_THAN_2_DAYS", "MORE_THAN_2_DAYS"]
        if not value_allowed_none_or_none_sentinel(acceptable_downtime, allowed_values):
            acceptable_downtime = 'UNKNOWN_ENUM_VALUE'
        self._acceptable_downtime = acceptable_downtime

    @property
    def database_data_size(self):
        """
        **[Required]** Gets the database_data_size of this Assessment.
        The size of a source database.

        Allowed values for this property are: "LESS_THAN_1GB", "GB_1_10", "GB_10_50", "GB_50_100", "GB_100_500", "GB_500_TB_1", "TB_1_3", "TB_3_10", "TB_10_50", "GREATER_THAN_50TB", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The database_data_size of this Assessment.
        :rtype: str
        """
        return self._database_data_size

    @database_data_size.setter
    def database_data_size(self, database_data_size):
        """
        Sets the database_data_size of this Assessment.
        The size of a source database.


        :param database_data_size: The database_data_size of this Assessment.
        :type: str
        """
        allowed_values = ["LESS_THAN_1GB", "GB_1_10", "GB_10_50", "GB_50_100", "GB_100_500", "GB_500_TB_1", "TB_1_3", "TB_3_10", "TB_10_50", "GREATER_THAN_50TB"]
        if not value_allowed_none_or_none_sentinel(database_data_size, allowed_values):
            database_data_size = 'UNKNOWN_ENUM_VALUE'
        self._database_data_size = database_data_size

    @property
    def ddl_expectation(self):
        """
        **[Required]** Gets the ddl_expectation of this Assessment.
        DDL expectation values.

        Allowed values for this property are: "DDL_EXPECTED", "DDL_NOT_EXPECTED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The ddl_expectation of this Assessment.
        :rtype: str
        """
        return self._ddl_expectation

    @ddl_expectation.setter
    def ddl_expectation(self, ddl_expectation):
        """
        Sets the ddl_expectation of this Assessment.
        DDL expectation values.


        :param ddl_expectation: The ddl_expectation of this Assessment.
        :type: str
        """
        allowed_values = ["DDL_EXPECTED", "DDL_NOT_EXPECTED"]
        if not value_allowed_none_or_none_sentinel(ddl_expectation, allowed_values):
            ddl_expectation = 'UNKNOWN_ENUM_VALUE'
        self._ddl_expectation = ddl_expectation

    @property
    def creation_type(self):
        """
        **[Required]** Gets the creation_type of this Assessment.
        The type of assessment creation.

        Allowed values for this property are: "CREATE_ONLY", "CREATE_AND_RUN_ASSESSORS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The creation_type of this Assessment.
        :rtype: str
        """
        return self._creation_type

    @creation_type.setter
    def creation_type(self, creation_type):
        """
        Sets the creation_type of this Assessment.
        The type of assessment creation.


        :param creation_type: The creation_type of this Assessment.
        :type: str
        """
        allowed_values = ["CREATE_ONLY", "CREATE_AND_RUN_ASSESSORS"]
        if not value_allowed_none_or_none_sentinel(creation_type, allowed_values):
            creation_type = 'UNKNOWN_ENUM_VALUE'
        self._creation_type = creation_type

    @property
    def migration_id(self):
        """
        Gets the migration_id of this Assessment.
        The OCID of the resource being referenced.


        :return: The migration_id of this Assessment.
        :rtype: str
        """
        return self._migration_id

    @migration_id.setter
    def migration_id(self, migration_id):
        """
        Sets the migration_id of this Assessment.
        The OCID of the resource being referenced.


        :param migration_id: The migration_id of this Assessment.
        :type: str
        """
        self._migration_id = migration_id

    @property
    def source_database_connection(self):
        """
        **[Required]** Gets the source_database_connection of this Assessment.

        :return: The source_database_connection of this Assessment.
        :rtype: oci.database_migration.models.SourceAssessmentConnection
        """
        return self._source_database_connection

    @source_database_connection.setter
    def source_database_connection(self, source_database_connection):
        """
        Sets the source_database_connection of this Assessment.

        :param source_database_connection: The source_database_connection of this Assessment.
        :type: oci.database_migration.models.SourceAssessmentConnection
        """
        self._source_database_connection = source_database_connection

    @property
    def target_database_connection(self):
        """
        **[Required]** Gets the target_database_connection of this Assessment.

        :return: The target_database_connection of this Assessment.
        :rtype: oci.database_migration.models.TargetAssessmentConnection
        """
        return self._target_database_connection

    @target_database_connection.setter
    def target_database_connection(self, target_database_connection):
        """
        Sets the target_database_connection of this Assessment.

        :param target_database_connection: The target_database_connection of this Assessment.
        :type: oci.database_migration.models.TargetAssessmentConnection
        """
        self._target_database_connection = target_database_connection

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this Assessment.
        The current state of the Assessment resource.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "SUCCEEDED", "IN_PROGRESS", "NEEDS_ATTENTION", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this Assessment.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this Assessment.
        The current state of the Assessment resource.


        :param lifecycle_state: The lifecycle_state of this Assessment.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "SUCCEEDED", "IN_PROGRESS", "NEEDS_ATTENTION", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def assessment_migration_type(self):
        """
        Gets the assessment_migration_type of this Assessment.
        The migration type of the migration to be performed.

        Allowed values for this property are: "ONLINE", "ONLINE_STANDBY", "OFFLINE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The assessment_migration_type of this Assessment.
        :rtype: str
        """
        return self._assessment_migration_type

    @assessment_migration_type.setter
    def assessment_migration_type(self, assessment_migration_type):
        """
        Sets the assessment_migration_type of this Assessment.
        The migration type of the migration to be performed.


        :param assessment_migration_type: The assessment_migration_type of this Assessment.
        :type: str
        """
        allowed_values = ["ONLINE", "ONLINE_STANDBY", "OFFLINE"]
        if not value_allowed_none_or_none_sentinel(assessment_migration_type, allowed_values):
            assessment_migration_type = 'UNKNOWN_ENUM_VALUE'
        self._assessment_migration_type = assessment_migration_type

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this Assessment.
        An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.


        :return: The time_created of this Assessment.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this Assessment.
        An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.


        :param time_created: The time_created of this Assessment.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this Assessment.
        An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.


        :return: The time_updated of this Assessment.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this Assessment.
        An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.


        :param time_updated: The time_updated of this Assessment.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this Assessment.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see Resource Tags. Example: {\"Department\": \"Finance\"}


        :return: The freeform_tags of this Assessment.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this Assessment.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see Resource Tags. Example: {\"Department\": \"Finance\"}


        :param freeform_tags: The freeform_tags of this Assessment.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this Assessment.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this Assessment.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this Assessment.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this Assessment.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this Assessment.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this Assessment.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this Assessment.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this Assessment.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
