# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AssessorAction(object):
    """
    Assessor Action
    """

    #: A constant which can be used with the name property of a AssessorAction.
    #: This constant has a value of "RUN"
    NAME_RUN = "RUN"

    #: A constant which can be used with the name property of a AssessorAction.
    #: This constant has a value of "CONFIGURE"
    NAME_CONFIGURE = "CONFIGURE"

    #: A constant which can be used with the name property of a AssessorAction.
    #: This constant has a value of "CONFIGURE_MIGRATION"
    NAME_CONFIGURE_MIGRATION = "CONFIGURE_MIGRATION"

    #: A constant which can be used with the name property of a AssessorAction.
    #: This constant has a value of "CREATE_MIGRATION"
    NAME_CREATE_MIGRATION = "CREATE_MIGRATION"

    #: A constant which can be used with the name property of a AssessorAction.
    #: This constant has a value of "UPDATE_MIGRATION"
    NAME_UPDATE_MIGRATION = "UPDATE_MIGRATION"

    #: A constant which can be used with the name property of a AssessorAction.
    #: This constant has a value of "RECHECK"
    NAME_RECHECK = "RECHECK"

    #: A constant which can be used with the name property of a AssessorAction.
    #: This constant has a value of "RUN_SQL"
    NAME_RUN_SQL = "RUN_SQL"

    #: A constant which can be used with the name property of a AssessorAction.
    #: This constant has a value of "DOWNLOAD_SQL"
    NAME_DOWNLOAD_SQL = "DOWNLOAD_SQL"

    #: A constant which can be used with the name property of a AssessorAction.
    #: This constant has a value of "DOWNLOAD_LOG"
    NAME_DOWNLOAD_LOG = "DOWNLOAD_LOG"

    #: A constant which can be used with the name property of a AssessorAction.
    #: This constant has a value of "CONFIRM"
    NAME_CONFIRM = "CONFIRM"

    #: A constant which can be used with the name property of a AssessorAction.
    #: This constant has a value of "MANAGE"
    NAME_MANAGE = "MANAGE"

    def __init__(self, **kwargs):
        """
        Initializes a new AssessorAction object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this AssessorAction.
            Allowed values for this property are: "RUN", "CONFIGURE", "CONFIGURE_MIGRATION", "CREATE_MIGRATION", "UPDATE_MIGRATION", "RECHECK", "RUN_SQL", "DOWNLOAD_SQL", "DOWNLOAD_LOG", "CONFIRM", "MANAGE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type name: str

        :param display_name:
            The value to assign to the display_name property of this AssessorAction.
        :type display_name: str

        :param title:
            The value to assign to the title property of this AssessorAction.
        :type title: str

        :param description:
            The value to assign to the description property of this AssessorAction.
        :type description: str

        :param is_disabled:
            The value to assign to the is_disabled property of this AssessorAction.
        :type is_disabled: bool

        :param user_defined_properties:
            The value to assign to the user_defined_properties property of this AssessorAction.
        :type user_defined_properties: oci.database_migration.models.UserDefinedProperties

        :param resource_id:
            The value to assign to the resource_id property of this AssessorAction.
        :type resource_id: str

        """
        self.swagger_types = {
            'name': 'str',
            'display_name': 'str',
            'title': 'str',
            'description': 'str',
            'is_disabled': 'bool',
            'user_defined_properties': 'UserDefinedProperties',
            'resource_id': 'str'
        }
        self.attribute_map = {
            'name': 'name',
            'display_name': 'displayName',
            'title': 'title',
            'description': 'description',
            'is_disabled': 'isDisabled',
            'user_defined_properties': 'userDefinedProperties',
            'resource_id': 'resourceId'
        }
        self._name = None
        self._display_name = None
        self._title = None
        self._description = None
        self._is_disabled = None
        self._user_defined_properties = None
        self._resource_id = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this AssessorAction.
        The Assessor Action Name.

        Allowed values for this property are: "RUN", "CONFIGURE", "CONFIGURE_MIGRATION", "CREATE_MIGRATION", "UPDATE_MIGRATION", "RECHECK", "RUN_SQL", "DOWNLOAD_SQL", "DOWNLOAD_LOG", "CONFIRM", "MANAGE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The name of this AssessorAction.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this AssessorAction.
        The Assessor Action Name.


        :param name: The name of this AssessorAction.
        :type: str
        """
        allowed_values = ["RUN", "CONFIGURE", "CONFIGURE_MIGRATION", "CREATE_MIGRATION", "UPDATE_MIGRATION", "RECHECK", "RUN_SQL", "DOWNLOAD_SQL", "DOWNLOAD_LOG", "CONFIRM", "MANAGE"]
        if not value_allowed_none_or_none_sentinel(name, allowed_values):
            name = 'UNKNOWN_ENUM_VALUE'
        self._name = name

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this AssessorAction.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this AssessorAction.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AssessorAction.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this AssessorAction.
        :type: str
        """
        self._display_name = display_name

    @property
    def title(self):
        """
        **[Required]** Gets the title of this AssessorAction.
        The Assessor Action Title.


        :return: The title of this AssessorAction.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this AssessorAction.
        The Assessor Action Title.


        :param title: The title of this AssessorAction.
        :type: str
        """
        self._title = title

    @property
    def description(self):
        """
        Gets the description of this AssessorAction.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The description of this AssessorAction.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this AssessorAction.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param description: The description of this AssessorAction.
        :type: str
        """
        self._description = description

    @property
    def is_disabled(self):
        """
        **[Required]** Gets the is_disabled of this AssessorAction.
        Defines if the action is enabled or disabled.


        :return: The is_disabled of this AssessorAction.
        :rtype: bool
        """
        return self._is_disabled

    @is_disabled.setter
    def is_disabled(self, is_disabled):
        """
        Sets the is_disabled of this AssessorAction.
        Defines if the action is enabled or disabled.


        :param is_disabled: The is_disabled of this AssessorAction.
        :type: bool
        """
        self._is_disabled = is_disabled

    @property
    def user_defined_properties(self):
        """
        Gets the user_defined_properties of this AssessorAction.

        :return: The user_defined_properties of this AssessorAction.
        :rtype: oci.database_migration.models.UserDefinedProperties
        """
        return self._user_defined_properties

    @user_defined_properties.setter
    def user_defined_properties(self, user_defined_properties):
        """
        Sets the user_defined_properties of this AssessorAction.

        :param user_defined_properties: The user_defined_properties of this AssessorAction.
        :type: oci.database_migration.models.UserDefinedProperties
        """
        self._user_defined_properties = user_defined_properties

    @property
    def resource_id(self):
        """
        Gets the resource_id of this AssessorAction.
        The OCID of the resource being referenced.


        :return: The resource_id of this AssessorAction.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this AssessorAction.
        The OCID of the resource being referenced.


        :param resource_id: The resource_id of this AssessorAction.
        :type: str
        """
        self._resource_id = resource_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
