# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AssessorCheckAction(object):
    """
    Assessor Check Action
    """

    #: A constant which can be used with the name property of a AssessorCheckAction.
    #: This constant has a value of "APPROVE"
    NAME_APPROVE = "APPROVE"

    #: A constant which can be used with the name property of a AssessorCheckAction.
    #: This constant has a value of "DISAPPROVE"
    NAME_DISAPPROVE = "DISAPPROVE"

    #: A constant which can be used with the name property of a AssessorCheckAction.
    #: This constant has a value of "ACKNOWLEDGE"
    NAME_ACKNOWLEDGE = "ACKNOWLEDGE"

    #: A constant which can be used with the name property of a AssessorCheckAction.
    #: This constant has a value of "UNACKNOWLEDGE"
    NAME_UNACKNOWLEDGE = "UNACKNOWLEDGE"

    def __init__(self, **kwargs):
        """
        Initializes a new AssessorCheckAction object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this AssessorCheckAction.
            Allowed values for this property are: "APPROVE", "DISAPPROVE", "ACKNOWLEDGE", "UNACKNOWLEDGE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type name: str

        :param display_name:
            The value to assign to the display_name property of this AssessorCheckAction.
        :type display_name: str

        :param description:
            The value to assign to the description property of this AssessorCheckAction.
        :type description: str

        :param user_defined_properties:
            The value to assign to the user_defined_properties property of this AssessorCheckAction.
        :type user_defined_properties: oci.database_migration.models.UserDefinedProperties

        """
        self.swagger_types = {
            'name': 'str',
            'display_name': 'str',
            'description': 'str',
            'user_defined_properties': 'UserDefinedProperties'
        }
        self.attribute_map = {
            'name': 'name',
            'display_name': 'displayName',
            'description': 'description',
            'user_defined_properties': 'userDefinedProperties'
        }
        self._name = None
        self._display_name = None
        self._description = None
        self._user_defined_properties = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this AssessorCheckAction.
        The Assessor Check Action Name.

        Allowed values for this property are: "APPROVE", "DISAPPROVE", "ACKNOWLEDGE", "UNACKNOWLEDGE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The name of this AssessorCheckAction.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this AssessorCheckAction.
        The Assessor Check Action Name.


        :param name: The name of this AssessorCheckAction.
        :type: str
        """
        allowed_values = ["APPROVE", "DISAPPROVE", "ACKNOWLEDGE", "UNACKNOWLEDGE"]
        if not value_allowed_none_or_none_sentinel(name, allowed_values):
            name = 'UNKNOWN_ENUM_VALUE'
        self._name = name

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this AssessorCheckAction.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this AssessorCheckAction.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AssessorCheckAction.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this AssessorCheckAction.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this AssessorCheckAction.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The description of this AssessorCheckAction.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this AssessorCheckAction.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param description: The description of this AssessorCheckAction.
        :type: str
        """
        self._description = description

    @property
    def user_defined_properties(self):
        """
        Gets the user_defined_properties of this AssessorCheckAction.

        :return: The user_defined_properties of this AssessorCheckAction.
        :rtype: oci.database_migration.models.UserDefinedProperties
        """
        return self._user_defined_properties

    @user_defined_properties.setter
    def user_defined_properties(self, user_defined_properties):
        """
        Sets the user_defined_properties of this AssessorCheckAction.

        :param user_defined_properties: The user_defined_properties of this AssessorCheckAction.
        :type: oci.database_migration.models.UserDefinedProperties
        """
        self._user_defined_properties = user_defined_properties

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
