# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AssessorGroup(object):
    """
    Assessor Group
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AssessorGroup object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this AssessorGroup.
        :type name: str

        :param display_name:
            The value to assign to the display_name property of this AssessorGroup.
        :type display_name: str

        :param description:
            The value to assign to the description property of this AssessorGroup.
        :type description: str

        :param actions:
            The value to assign to the actions property of this AssessorGroup.
        :type actions: list[oci.database_migration.models.AssessorAction]

        """
        self.swagger_types = {
            'name': 'str',
            'display_name': 'str',
            'description': 'str',
            'actions': 'list[AssessorAction]'
        }
        self.attribute_map = {
            'name': 'name',
            'display_name': 'displayName',
            'description': 'description',
            'actions': 'actions'
        }
        self._name = None
        self._display_name = None
        self._description = None
        self._actions = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this AssessorGroup.
        Assessor Group name, e.g. ADVANCED.


        :return: The name of this AssessorGroup.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this AssessorGroup.
        Assessor Group name, e.g. ADVANCED.


        :param name: The name of this AssessorGroup.
        :type: str
        """
        self._name = name

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this AssessorGroup.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this AssessorGroup.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AssessorGroup.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this AssessorGroup.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this AssessorGroup.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The description of this AssessorGroup.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this AssessorGroup.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param description: The description of this AssessorGroup.
        :type: str
        """
        self._description = description

    @property
    def actions(self):
        """
        Gets the actions of this AssessorGroup.
        Assessor group actions.


        :return: The actions of this AssessorGroup.
        :rtype: list[oci.database_migration.models.AssessorAction]
        """
        return self._actions

    @actions.setter
    def actions(self, actions):
        """
        Sets the actions of this AssessorGroup.
        Assessor group actions.


        :param actions: The actions of this AssessorGroup.
        :type: list[oci.database_migration.models.AssessorAction]
        """
        self._actions = actions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
