# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518

from .create_assessment_details import CreateAssessmentDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateOracleAssessmentDetails(CreateAssessmentDetails):
    """
    Create Oracle Assessment resource parameters.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateOracleAssessmentDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database_migration.models.CreateOracleAssessmentDetails.database_combination` attribute
        of this class is ``ORACLE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param description:
            The value to assign to the description property of this CreateOracleAssessmentDetails.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateOracleAssessmentDetails.
        :type compartment_id: str

        :param database_combination:
            The value to assign to the database_combination property of this CreateOracleAssessmentDetails.
            Allowed values for this property are: "MYSQL", "ORACLE"
        :type database_combination: str

        :param display_name:
            The value to assign to the display_name property of this CreateOracleAssessmentDetails.
        :type display_name: str

        :param network_speed_megabit_per_second:
            The value to assign to the network_speed_megabit_per_second property of this CreateOracleAssessmentDetails.
            Allowed values for this property are: "MBPS_10", "MBPS_100", "MBPS_1000", "MBPS_2500", "MBPS_5000", "MBPS_10000"
        :type network_speed_megabit_per_second: str

        :param acceptable_downtime:
            The value to assign to the acceptable_downtime property of this CreateOracleAssessmentDetails.
            Allowed values for this property are: "LESS_THAN_10_MINUTES", "LESS_THAN_1_HOUR", "LESS_THAN_4_HOURS", "LESS_THAN_8_HOURS", "LESS_THAN_12_HOURS", "LESS_THAN_1_DAY", "LESS_THAN_2_DAYS", "MORE_THAN_2_DAYS"
        :type acceptable_downtime: str

        :param database_data_size:
            The value to assign to the database_data_size property of this CreateOracleAssessmentDetails.
            Allowed values for this property are: "LESS_THAN_1GB", "GB_1_10", "GB_10_50", "GB_50_100", "GB_100_500", "GB_500_TB_1", "TB_1_3", "TB_3_10", "TB_10_50", "GREATER_THAN_50TB"
        :type database_data_size: str

        :param ddl_expectation:
            The value to assign to the ddl_expectation property of this CreateOracleAssessmentDetails.
            Allowed values for this property are: "DDL_EXPECTED", "DDL_NOT_EXPECTED"
        :type ddl_expectation: str

        :param creation_type:
            The value to assign to the creation_type property of this CreateOracleAssessmentDetails.
            Allowed values for this property are: "CREATE_ONLY", "CREATE_AND_RUN_ASSESSORS"
        :type creation_type: str

        :param source_database_connection:
            The value to assign to the source_database_connection property of this CreateOracleAssessmentDetails.
        :type source_database_connection: oci.database_migration.models.SourceAssessmentConnection

        :param target_database_connection:
            The value to assign to the target_database_connection property of this CreateOracleAssessmentDetails.
        :type target_database_connection: oci.database_migration.models.TargetAssessmentConnection

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateOracleAssessmentDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateOracleAssessmentDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param exclude_objects:
            The value to assign to the exclude_objects property of this CreateOracleAssessmentDetails.
        :type exclude_objects: list[oci.database_migration.models.OracleDatabaseObject]

        :param include_objects:
            The value to assign to the include_objects property of this CreateOracleAssessmentDetails.
        :type include_objects: list[oci.database_migration.models.OracleDatabaseObject]

        :param bulk_include_exclude_data:
            The value to assign to the bulk_include_exclude_data property of this CreateOracleAssessmentDetails.
        :type bulk_include_exclude_data: str

        """
        self.swagger_types = {
            'description': 'str',
            'compartment_id': 'str',
            'database_combination': 'str',
            'display_name': 'str',
            'network_speed_megabit_per_second': 'str',
            'acceptable_downtime': 'str',
            'database_data_size': 'str',
            'ddl_expectation': 'str',
            'creation_type': 'str',
            'source_database_connection': 'SourceAssessmentConnection',
            'target_database_connection': 'TargetAssessmentConnection',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'exclude_objects': 'list[OracleDatabaseObject]',
            'include_objects': 'list[OracleDatabaseObject]',
            'bulk_include_exclude_data': 'str'
        }
        self.attribute_map = {
            'description': 'description',
            'compartment_id': 'compartmentId',
            'database_combination': 'databaseCombination',
            'display_name': 'displayName',
            'network_speed_megabit_per_second': 'networkSpeedMegabitPerSecond',
            'acceptable_downtime': 'acceptableDowntime',
            'database_data_size': 'databaseDataSize',
            'ddl_expectation': 'ddlExpectation',
            'creation_type': 'creationType',
            'source_database_connection': 'sourceDatabaseConnection',
            'target_database_connection': 'targetDatabaseConnection',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'exclude_objects': 'excludeObjects',
            'include_objects': 'includeObjects',
            'bulk_include_exclude_data': 'bulkIncludeExcludeData'
        }
        self._description = None
        self._compartment_id = None
        self._database_combination = None
        self._display_name = None
        self._network_speed_megabit_per_second = None
        self._acceptable_downtime = None
        self._database_data_size = None
        self._ddl_expectation = None
        self._creation_type = None
        self._source_database_connection = None
        self._target_database_connection = None
        self._freeform_tags = None
        self._defined_tags = None
        self._exclude_objects = None
        self._include_objects = None
        self._bulk_include_exclude_data = None
        self._database_combination = 'ORACLE'

    @property
    def exclude_objects(self):
        """
        Gets the exclude_objects of this CreateOracleAssessmentDetails.
        Database objects to exclude from migration, cannot be specified alongside 'includeObjects'


        :return: The exclude_objects of this CreateOracleAssessmentDetails.
        :rtype: list[oci.database_migration.models.OracleDatabaseObject]
        """
        return self._exclude_objects

    @exclude_objects.setter
    def exclude_objects(self, exclude_objects):
        """
        Sets the exclude_objects of this CreateOracleAssessmentDetails.
        Database objects to exclude from migration, cannot be specified alongside 'includeObjects'


        :param exclude_objects: The exclude_objects of this CreateOracleAssessmentDetails.
        :type: list[oci.database_migration.models.OracleDatabaseObject]
        """
        self._exclude_objects = exclude_objects

    @property
    def include_objects(self):
        """
        Gets the include_objects of this CreateOracleAssessmentDetails.
        Database objects to include from migration, cannot be specified alongside 'excludeObjects'


        :return: The include_objects of this CreateOracleAssessmentDetails.
        :rtype: list[oci.database_migration.models.OracleDatabaseObject]
        """
        return self._include_objects

    @include_objects.setter
    def include_objects(self, include_objects):
        """
        Sets the include_objects of this CreateOracleAssessmentDetails.
        Database objects to include from migration, cannot be specified alongside 'excludeObjects'


        :param include_objects: The include_objects of this CreateOracleAssessmentDetails.
        :type: list[oci.database_migration.models.OracleDatabaseObject]
        """
        self._include_objects = include_objects

    @property
    def bulk_include_exclude_data(self):
        """
        Gets the bulk_include_exclude_data of this CreateOracleAssessmentDetails.
        Specifies the database objects to be excluded from the migration in bulk.
        The definition accepts input in a CSV format, newline separated for each entry.
        More details can be found in the documentation.


        :return: The bulk_include_exclude_data of this CreateOracleAssessmentDetails.
        :rtype: str
        """
        return self._bulk_include_exclude_data

    @bulk_include_exclude_data.setter
    def bulk_include_exclude_data(self, bulk_include_exclude_data):
        """
        Sets the bulk_include_exclude_data of this CreateOracleAssessmentDetails.
        Specifies the database objects to be excluded from the migration in bulk.
        The definition accepts input in a CSV format, newline separated for each entry.
        More details can be found in the documentation.


        :param bulk_include_exclude_data: The bulk_include_exclude_data of this CreateOracleAssessmentDetails.
        :type: str
        """
        self._bulk_include_exclude_data = bulk_include_exclude_data

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
