# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatabaseInformation(object):
    """
    Database Information.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DatabaseInformation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param database_name:
            The value to assign to the database_name property of this DatabaseInformation.
        :type database_name: str

        :param database_version:
            The value to assign to the database_version property of this DatabaseInformation.
        :type database_version: str

        :param data_size_in_mbs:
            The value to assign to the data_size_in_mbs property of this DatabaseInformation.
        :type data_size_in_mbs: int

        """
        self.swagger_types = {
            'database_name': 'str',
            'database_version': 'str',
            'data_size_in_mbs': 'int'
        }
        self.attribute_map = {
            'database_name': 'databaseName',
            'database_version': 'databaseVersion',
            'data_size_in_mbs': 'dataSizeInMBs'
        }
        self._database_name = None
        self._database_version = None
        self._data_size_in_mbs = None

    @property
    def database_name(self):
        """
        Gets the database_name of this DatabaseInformation.
        The database name.


        :return: The database_name of this DatabaseInformation.
        :rtype: str
        """
        return self._database_name

    @database_name.setter
    def database_name(self, database_name):
        """
        Sets the database_name of this DatabaseInformation.
        The database name.


        :param database_name: The database_name of this DatabaseInformation.
        :type: str
        """
        self._database_name = database_name

    @property
    def database_version(self):
        """
        Gets the database_version of this DatabaseInformation.
        The database version.


        :return: The database_version of this DatabaseInformation.
        :rtype: str
        """
        return self._database_version

    @database_version.setter
    def database_version(self, database_version):
        """
        Sets the database_version of this DatabaseInformation.
        The database version.


        :param database_version: The database_version of this DatabaseInformation.
        :type: str
        """
        self._database_version = database_version

    @property
    def data_size_in_mbs(self):
        """
        Gets the data_size_in_mbs of this DatabaseInformation.
        The total size of the database in megabytes.


        :return: The data_size_in_mbs of this DatabaseInformation.
        :rtype: int
        """
        return self._data_size_in_mbs

    @data_size_in_mbs.setter
    def data_size_in_mbs(self, data_size_in_mbs):
        """
        Sets the data_size_in_mbs of this DatabaseInformation.
        The total size of the database in megabytes.


        :param data_size_in_mbs: The data_size_in_mbs of this DatabaseInformation.
        :type: int
        """
        self._data_size_in_mbs = data_size_in_mbs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
