# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatabaseTechnologySubType(object):
    """
    Technology sub-type e.g. ADW_SHARED and database versions corresponding to the sub-type.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DatabaseTechnologySubType object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param technology_sub_type:
            The value to assign to the technology_sub_type property of this DatabaseTechnologySubType.
        :type technology_sub_type: str

        :param technology_sub_type_display_name:
            The value to assign to the technology_sub_type_display_name property of this DatabaseTechnologySubType.
        :type technology_sub_type_display_name: str

        :param database_versions:
            The value to assign to the database_versions property of this DatabaseTechnologySubType.
        :type database_versions: list[str]

        """
        self.swagger_types = {
            'technology_sub_type': 'str',
            'technology_sub_type_display_name': 'str',
            'database_versions': 'list[str]'
        }
        self.attribute_map = {
            'technology_sub_type': 'technologySubType',
            'technology_sub_type_display_name': 'technologySubTypeDisplayName',
            'database_versions': 'databaseVersions'
        }
        self._technology_sub_type = None
        self._technology_sub_type_display_name = None
        self._database_versions = None

    @property
    def technology_sub_type(self):
        """
        Gets the technology_sub_type of this DatabaseTechnologySubType.
        Technology sub-type e.g. ADW_SHARED.


        :return: The technology_sub_type of this DatabaseTechnologySubType.
        :rtype: str
        """
        return self._technology_sub_type

    @technology_sub_type.setter
    def technology_sub_type(self, technology_sub_type):
        """
        Sets the technology_sub_type of this DatabaseTechnologySubType.
        Technology sub-type e.g. ADW_SHARED.


        :param technology_sub_type: The technology_sub_type of this DatabaseTechnologySubType.
        :type: str
        """
        self._technology_sub_type = technology_sub_type

    @property
    def technology_sub_type_display_name(self):
        """
        Gets the technology_sub_type_display_name of this DatabaseTechnologySubType.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The technology_sub_type_display_name of this DatabaseTechnologySubType.
        :rtype: str
        """
        return self._technology_sub_type_display_name

    @technology_sub_type_display_name.setter
    def technology_sub_type_display_name(self, technology_sub_type_display_name):
        """
        Sets the technology_sub_type_display_name of this DatabaseTechnologySubType.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param technology_sub_type_display_name: The technology_sub_type_display_name of this DatabaseTechnologySubType.
        :type: str
        """
        self._technology_sub_type_display_name = technology_sub_type_display_name

    @property
    def database_versions(self):
        """
        Gets the database_versions of this DatabaseTechnologySubType.
        Array of database versions


        :return: The database_versions of this DatabaseTechnologySubType.
        :rtype: list[str]
        """
        return self._database_versions

    @database_versions.setter
    def database_versions(self, database_versions):
        """
        Sets the database_versions of this DatabaseTechnologySubType.
        Array of database versions


        :param database_versions: The database_versions of this DatabaseTechnologySubType.
        :type: list[str]
        """
        self._database_versions = database_versions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
