# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GoldenGateHubDetails(object):
    """
    Details about Oracle GoldenGate Microservices.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GoldenGateHubDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param rest_admin_credentials:
            The value to assign to the rest_admin_credentials property of this GoldenGateHubDetails.
        :type rest_admin_credentials: oci.database_migration.models.AdminCredentials

        :param url:
            The value to assign to the url property of this GoldenGateHubDetails.
        :type url: str

        :param compute_id:
            The value to assign to the compute_id property of this GoldenGateHubDetails.
        :type compute_id: str

        :param vault_id:
            The value to assign to the vault_id property of this GoldenGateHubDetails.
        :type vault_id: str

        :param key_id:
            The value to assign to the key_id property of this GoldenGateHubDetails.
        :type key_id: str

        :param extract:
            The value to assign to the extract property of this GoldenGateHubDetails.
        :type extract: oci.database_migration.models.Extract

        :param replicat:
            The value to assign to the replicat property of this GoldenGateHubDetails.
        :type replicat: oci.database_migration.models.Replicat

        :param acceptable_lag:
            The value to assign to the acceptable_lag property of this GoldenGateHubDetails.
        :type acceptable_lag: int

        """
        self.swagger_types = {
            'rest_admin_credentials': 'AdminCredentials',
            'url': 'str',
            'compute_id': 'str',
            'vault_id': 'str',
            'key_id': 'str',
            'extract': 'Extract',
            'replicat': 'Replicat',
            'acceptable_lag': 'int'
        }
        self.attribute_map = {
            'rest_admin_credentials': 'restAdminCredentials',
            'url': 'url',
            'compute_id': 'computeId',
            'vault_id': 'vaultId',
            'key_id': 'keyId',
            'extract': 'extract',
            'replicat': 'replicat',
            'acceptable_lag': 'acceptableLag'
        }
        self._rest_admin_credentials = None
        self._url = None
        self._compute_id = None
        self._vault_id = None
        self._key_id = None
        self._extract = None
        self._replicat = None
        self._acceptable_lag = None

    @property
    def rest_admin_credentials(self):
        """
        **[Required]** Gets the rest_admin_credentials of this GoldenGateHubDetails.

        :return: The rest_admin_credentials of this GoldenGateHubDetails.
        :rtype: oci.database_migration.models.AdminCredentials
        """
        return self._rest_admin_credentials

    @rest_admin_credentials.setter
    def rest_admin_credentials(self, rest_admin_credentials):
        """
        Sets the rest_admin_credentials of this GoldenGateHubDetails.

        :param rest_admin_credentials: The rest_admin_credentials of this GoldenGateHubDetails.
        :type: oci.database_migration.models.AdminCredentials
        """
        self._rest_admin_credentials = rest_admin_credentials

    @property
    def url(self):
        """
        **[Required]** Gets the url of this GoldenGateHubDetails.
        Endpoint URL.


        :return: The url of this GoldenGateHubDetails.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this GoldenGateHubDetails.
        Endpoint URL.


        :param url: The url of this GoldenGateHubDetails.
        :type: str
        """
        self._url = url

    @property
    def compute_id(self):
        """
        Gets the compute_id of this GoldenGateHubDetails.
        The OCID of the resource being referenced.


        :return: The compute_id of this GoldenGateHubDetails.
        :rtype: str
        """
        return self._compute_id

    @compute_id.setter
    def compute_id(self, compute_id):
        """
        Sets the compute_id of this GoldenGateHubDetails.
        The OCID of the resource being referenced.


        :param compute_id: The compute_id of this GoldenGateHubDetails.
        :type: str
        """
        self._compute_id = compute_id

    @property
    def vault_id(self):
        """
        **[Required]** Gets the vault_id of this GoldenGateHubDetails.
        The OCID of the resource being referenced.


        :return: The vault_id of this GoldenGateHubDetails.
        :rtype: str
        """
        return self._vault_id

    @vault_id.setter
    def vault_id(self, vault_id):
        """
        Sets the vault_id of this GoldenGateHubDetails.
        The OCID of the resource being referenced.


        :param vault_id: The vault_id of this GoldenGateHubDetails.
        :type: str
        """
        self._vault_id = vault_id

    @property
    def key_id(self):
        """
        **[Required]** Gets the key_id of this GoldenGateHubDetails.
        The OCID of the resource being referenced.


        :return: The key_id of this GoldenGateHubDetails.
        :rtype: str
        """
        return self._key_id

    @key_id.setter
    def key_id(self, key_id):
        """
        Sets the key_id of this GoldenGateHubDetails.
        The OCID of the resource being referenced.


        :param key_id: The key_id of this GoldenGateHubDetails.
        :type: str
        """
        self._key_id = key_id

    @property
    def extract(self):
        """
        Gets the extract of this GoldenGateHubDetails.

        :return: The extract of this GoldenGateHubDetails.
        :rtype: oci.database_migration.models.Extract
        """
        return self._extract

    @extract.setter
    def extract(self, extract):
        """
        Sets the extract of this GoldenGateHubDetails.

        :param extract: The extract of this GoldenGateHubDetails.
        :type: oci.database_migration.models.Extract
        """
        self._extract = extract

    @property
    def replicat(self):
        """
        Gets the replicat of this GoldenGateHubDetails.

        :return: The replicat of this GoldenGateHubDetails.
        :rtype: oci.database_migration.models.Replicat
        """
        return self._replicat

    @replicat.setter
    def replicat(self, replicat):
        """
        Sets the replicat of this GoldenGateHubDetails.

        :param replicat: The replicat of this GoldenGateHubDetails.
        :type: oci.database_migration.models.Replicat
        """
        self._replicat = replicat

    @property
    def acceptable_lag(self):
        """
        Gets the acceptable_lag of this GoldenGateHubDetails.
        ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.


        :return: The acceptable_lag of this GoldenGateHubDetails.
        :rtype: int
        """
        return self._acceptable_lag

    @acceptable_lag.setter
    def acceptable_lag(self, acceptable_lag):
        """
        Sets the acceptable_lag of this GoldenGateHubDetails.
        ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.


        :param acceptable_lag: The acceptable_lag of this GoldenGateHubDetails.
        :type: int
        """
        self._acceptable_lag = acceptable_lag

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
