# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518

from .assessment import Assessment
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MySqlAssessment(Assessment):
    """
    MySql Assessment resource
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MySqlAssessment object with values from keyword arguments. The default value of the :py:attr:`~oci.database_migration.models.MySqlAssessment.database_combination` attribute
        of this class is ``MYSQL`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this MySqlAssessment.
        :type id: str

        :param description:
            The value to assign to the description property of this MySqlAssessment.
        :type description: str

        :param database_combination:
            The value to assign to the database_combination property of this MySqlAssessment.
            Allowed values for this property are: "MYSQL", "ORACLE"
        :type database_combination: str

        :param display_name:
            The value to assign to the display_name property of this MySqlAssessment.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this MySqlAssessment.
        :type compartment_id: str

        :param network_speed_megabit_per_second:
            The value to assign to the network_speed_megabit_per_second property of this MySqlAssessment.
            Allowed values for this property are: "MBPS_10", "MBPS_100", "MBPS_1000", "MBPS_2500", "MBPS_5000", "MBPS_10000"
        :type network_speed_megabit_per_second: str

        :param acceptable_downtime:
            The value to assign to the acceptable_downtime property of this MySqlAssessment.
            Allowed values for this property are: "LESS_THAN_10_MINUTES", "LESS_THAN_1_HOUR", "LESS_THAN_4_HOURS", "LESS_THAN_8_HOURS", "LESS_THAN_12_HOURS", "LESS_THAN_1_DAY", "LESS_THAN_2_DAYS", "MORE_THAN_2_DAYS"
        :type acceptable_downtime: str

        :param database_data_size:
            The value to assign to the database_data_size property of this MySqlAssessment.
            Allowed values for this property are: "LESS_THAN_1GB", "GB_1_10", "GB_10_50", "GB_50_100", "GB_100_500", "GB_500_TB_1", "TB_1_3", "TB_3_10", "TB_10_50", "GREATER_THAN_50TB"
        :type database_data_size: str

        :param ddl_expectation:
            The value to assign to the ddl_expectation property of this MySqlAssessment.
            Allowed values for this property are: "DDL_EXPECTED", "DDL_NOT_EXPECTED"
        :type ddl_expectation: str

        :param creation_type:
            The value to assign to the creation_type property of this MySqlAssessment.
            Allowed values for this property are: "CREATE_ONLY", "CREATE_AND_RUN_ASSESSORS"
        :type creation_type: str

        :param migration_id:
            The value to assign to the migration_id property of this MySqlAssessment.
        :type migration_id: str

        :param source_database_connection:
            The value to assign to the source_database_connection property of this MySqlAssessment.
        :type source_database_connection: oci.database_migration.models.SourceAssessmentConnection

        :param target_database_connection:
            The value to assign to the target_database_connection property of this MySqlAssessment.
        :type target_database_connection: oci.database_migration.models.TargetAssessmentConnection

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this MySqlAssessment.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "SUCCEEDED", "IN_PROGRESS", "NEEDS_ATTENTION", "DELETING", "DELETED", "FAILED"
        :type lifecycle_state: str

        :param assessment_migration_type:
            The value to assign to the assessment_migration_type property of this MySqlAssessment.
            Allowed values for this property are: "ONLINE", "ONLINE_STANDBY", "OFFLINE"
        :type assessment_migration_type: str

        :param time_created:
            The value to assign to the time_created property of this MySqlAssessment.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this MySqlAssessment.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this MySqlAssessment.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this MySqlAssessment.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this MySqlAssessment.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'description': 'str',
            'database_combination': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'network_speed_megabit_per_second': 'str',
            'acceptable_downtime': 'str',
            'database_data_size': 'str',
            'ddl_expectation': 'str',
            'creation_type': 'str',
            'migration_id': 'str',
            'source_database_connection': 'SourceAssessmentConnection',
            'target_database_connection': 'TargetAssessmentConnection',
            'lifecycle_state': 'str',
            'assessment_migration_type': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'description': 'description',
            'database_combination': 'databaseCombination',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'network_speed_megabit_per_second': 'networkSpeedMegabitPerSecond',
            'acceptable_downtime': 'acceptableDowntime',
            'database_data_size': 'databaseDataSize',
            'ddl_expectation': 'ddlExpectation',
            'creation_type': 'creationType',
            'migration_id': 'migrationId',
            'source_database_connection': 'sourceDatabaseConnection',
            'target_database_connection': 'targetDatabaseConnection',
            'lifecycle_state': 'lifecycleState',
            'assessment_migration_type': 'assessmentMigrationType',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._description = None
        self._database_combination = None
        self._display_name = None
        self._compartment_id = None
        self._network_speed_megabit_per_second = None
        self._acceptable_downtime = None
        self._database_data_size = None
        self._ddl_expectation = None
        self._creation_type = None
        self._migration_id = None
        self._source_database_connection = None
        self._target_database_connection = None
        self._lifecycle_state = None
        self._assessment_migration_type = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._database_combination = 'MYSQL'

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
