# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ObjectMetadata(object):
    """
    Metadata of object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ObjectMetadata object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param schema_owner_column:
            The value to assign to the schema_owner_column property of this ObjectMetadata.
        :type schema_owner_column: str

        :param object_name_column:
            The value to assign to the object_name_column property of this ObjectMetadata.
        :type object_name_column: str

        :param object_type_fixed:
            The value to assign to the object_type_fixed property of this ObjectMetadata.
        :type object_type_fixed: str

        :param object_type_column:
            The value to assign to the object_type_column property of this ObjectMetadata.
        :type object_type_column: str

        """
        self.swagger_types = {
            'schema_owner_column': 'str',
            'object_name_column': 'str',
            'object_type_fixed': 'str',
            'object_type_column': 'str'
        }
        self.attribute_map = {
            'schema_owner_column': 'schemaOwnerColumn',
            'object_name_column': 'objectNameColumn',
            'object_type_fixed': 'objectTypeFixed',
            'object_type_column': 'objectTypeColumn'
        }
        self._schema_owner_column = None
        self._object_name_column = None
        self._object_type_fixed = None
        self._object_type_column = None

    @property
    def schema_owner_column(self):
        """
        **[Required]** Gets the schema_owner_column of this ObjectMetadata.
        The field that stores the owner of the object.


        :return: The schema_owner_column of this ObjectMetadata.
        :rtype: str
        """
        return self._schema_owner_column

    @schema_owner_column.setter
    def schema_owner_column(self, schema_owner_column):
        """
        Sets the schema_owner_column of this ObjectMetadata.
        The field that stores the owner of the object.


        :param schema_owner_column: The schema_owner_column of this ObjectMetadata.
        :type: str
        """
        self._schema_owner_column = schema_owner_column

    @property
    def object_name_column(self):
        """
        **[Required]** Gets the object_name_column of this ObjectMetadata.
        The field that stores the name of the object.


        :return: The object_name_column of this ObjectMetadata.
        :rtype: str
        """
        return self._object_name_column

    @object_name_column.setter
    def object_name_column(self, object_name_column):
        """
        Sets the object_name_column of this ObjectMetadata.
        The field that stores the name of the object.


        :param object_name_column: The object_name_column of this ObjectMetadata.
        :type: str
        """
        self._object_name_column = object_name_column

    @property
    def object_type_fixed(self):
        """
        Gets the object_type_fixed of this ObjectMetadata.
        The field that stores the fixed type of the object.


        :return: The object_type_fixed of this ObjectMetadata.
        :rtype: str
        """
        return self._object_type_fixed

    @object_type_fixed.setter
    def object_type_fixed(self, object_type_fixed):
        """
        Sets the object_type_fixed of this ObjectMetadata.
        The field that stores the fixed type of the object.


        :param object_type_fixed: The object_type_fixed of this ObjectMetadata.
        :type: str
        """
        self._object_type_fixed = object_type_fixed

    @property
    def object_type_column(self):
        """
        Gets the object_type_column of this ObjectMetadata.
        The field that stores the type of the object.


        :return: The object_type_column of this ObjectMetadata.
        :rtype: str
        """
        return self._object_type_column

    @object_type_column.setter
    def object_type_column(self, object_type_column):
        """
        Sets the object_type_column of this ObjectMetadata.
        The field that stores the type of the object.


        :param object_type_column: The object_type_column of this ObjectMetadata.
        :type: str
        """
        self._object_type_column = object_type_column

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
