# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518

from .assessment_summary import AssessmentSummary
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OracleAssessmentSummary(AssessmentSummary):
    """
    Oracle Assessment Summary
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OracleAssessmentSummary object with values from keyword arguments. The default value of the :py:attr:`~oci.database_migration.models.OracleAssessmentSummary.database_combination` attribute
        of this class is ``ORACLE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this OracleAssessmentSummary.
        :type id: str

        :param database_combination:
            The value to assign to the database_combination property of this OracleAssessmentSummary.
            Allowed values for this property are: "MYSQL", "ORACLE"
        :type database_combination: str

        :param display_name:
            The value to assign to the display_name property of this OracleAssessmentSummary.
        :type display_name: str

        :param migration_id:
            The value to assign to the migration_id property of this OracleAssessmentSummary.
        :type migration_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this OracleAssessmentSummary.
        :type compartment_id: str

        :param time_created:
            The value to assign to the time_created property of this OracleAssessmentSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this OracleAssessmentSummary.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this OracleAssessmentSummary.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "SUCCEEDED", "IN_PROGRESS", "NEEDS_ATTENTION", "DELETING", "DELETED", "FAILED"
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this OracleAssessmentSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this OracleAssessmentSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this OracleAssessmentSummary.
        :type system_tags: dict(str, dict(str, object))

        :param is_cdb_supported:
            The value to assign to the is_cdb_supported property of this OracleAssessmentSummary.
        :type is_cdb_supported: bool

        """
        self.swagger_types = {
            'id': 'str',
            'database_combination': 'str',
            'display_name': 'str',
            'migration_id': 'str',
            'compartment_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'is_cdb_supported': 'bool'
        }
        self.attribute_map = {
            'id': 'id',
            'database_combination': 'databaseCombination',
            'display_name': 'displayName',
            'migration_id': 'migrationId',
            'compartment_id': 'compartmentId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'is_cdb_supported': 'isCdbSupported'
        }
        self._id = None
        self._database_combination = None
        self._display_name = None
        self._migration_id = None
        self._compartment_id = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._is_cdb_supported = None
        self._database_combination = 'ORACLE'

    @property
    def is_cdb_supported(self):
        """
        Gets the is_cdb_supported of this OracleAssessmentSummary.
        True if CDB should be defined, false otherwise.


        :return: The is_cdb_supported of this OracleAssessmentSummary.
        :rtype: bool
        """
        return self._is_cdb_supported

    @is_cdb_supported.setter
    def is_cdb_supported(self, is_cdb_supported):
        """
        Sets the is_cdb_supported of this OracleAssessmentSummary.
        True if CDB should be defined, false otherwise.


        :param is_cdb_supported: The is_cdb_supported of this OracleAssessmentSummary.
        :type: bool
        """
        self._is_cdb_supported = is_cdb_supported

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
