# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TargetAssessmentConnection(object):
    """
    Target Assessment Connection object
    """

    #: A constant which can be used with the connection_type property of a TargetAssessmentConnection.
    #: This constant has a value of "MYSQL"
    CONNECTION_TYPE_MYSQL = "MYSQL"

    #: A constant which can be used with the connection_type property of a TargetAssessmentConnection.
    #: This constant has a value of "ORACLE"
    CONNECTION_TYPE_ORACLE = "ORACLE"

    #: A constant which can be used with the technology_type property of a TargetAssessmentConnection.
    #: This constant has a value of "OCI_AUTONOMOUS_DATABASE"
    TECHNOLOGY_TYPE_OCI_AUTONOMOUS_DATABASE = "OCI_AUTONOMOUS_DATABASE"

    #: A constant which can be used with the technology_type property of a TargetAssessmentConnection.
    #: This constant has a value of "OCI_MYSQL"
    TECHNOLOGY_TYPE_OCI_MYSQL = "OCI_MYSQL"

    #: A constant which can be used with the technology_type property of a TargetAssessmentConnection.
    #: This constant has a value of "ORACLE_DATABASE"
    TECHNOLOGY_TYPE_ORACLE_DATABASE = "ORACLE_DATABASE"

    #: A constant which can be used with the technology_type property of a TargetAssessmentConnection.
    #: This constant has a value of "ORACLE_EXADATA"
    TECHNOLOGY_TYPE_ORACLE_EXADATA = "ORACLE_EXADATA"

    #: A constant which can be used with the technology_type property of a TargetAssessmentConnection.
    #: This constant has a value of "AMAZON_RDS_ORACLE"
    TECHNOLOGY_TYPE_AMAZON_RDS_ORACLE = "AMAZON_RDS_ORACLE"

    #: A constant which can be used with the technology_type property of a TargetAssessmentConnection.
    #: This constant has a value of "AMAZON_AURORA_MYSQL"
    TECHNOLOGY_TYPE_AMAZON_AURORA_MYSQL = "AMAZON_AURORA_MYSQL"

    #: A constant which can be used with the technology_type property of a TargetAssessmentConnection.
    #: This constant has a value of "AMAZON_RDS_MYSQL"
    TECHNOLOGY_TYPE_AMAZON_RDS_MYSQL = "AMAZON_RDS_MYSQL"

    #: A constant which can be used with the technology_type property of a TargetAssessmentConnection.
    #: This constant has a value of "AZURE_MYSQL"
    TECHNOLOGY_TYPE_AZURE_MYSQL = "AZURE_MYSQL"

    #: A constant which can be used with the technology_type property of a TargetAssessmentConnection.
    #: This constant has a value of "GOOGLE_CLOUD_SQL_MYSQL"
    TECHNOLOGY_TYPE_GOOGLE_CLOUD_SQL_MYSQL = "GOOGLE_CLOUD_SQL_MYSQL"

    #: A constant which can be used with the technology_type property of a TargetAssessmentConnection.
    #: This constant has a value of "MYSQL_SERVER"
    TECHNOLOGY_TYPE_MYSQL_SERVER = "MYSQL_SERVER"

    def __init__(self, **kwargs):
        """
        Initializes a new TargetAssessmentConnection object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this TargetAssessmentConnection.
        :type id: str

        :param connection_type:
            The value to assign to the connection_type property of this TargetAssessmentConnection.
            Allowed values for this property are: "MYSQL", "ORACLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type connection_type: str

        :param technology_type:
            The value to assign to the technology_type property of this TargetAssessmentConnection.
            Allowed values for this property are: "OCI_AUTONOMOUS_DATABASE", "OCI_MYSQL", "ORACLE_DATABASE", "ORACLE_EXADATA", "AMAZON_RDS_ORACLE", "AMAZON_AURORA_MYSQL", "AMAZON_RDS_MYSQL", "AZURE_MYSQL", "GOOGLE_CLOUD_SQL_MYSQL", "MYSQL_SERVER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type technology_type: str

        :param technology_sub_type:
            The value to assign to the technology_sub_type property of this TargetAssessmentConnection.
        :type technology_sub_type: str

        :param database_version:
            The value to assign to the database_version property of this TargetAssessmentConnection.
        :type database_version: str

        """
        self.swagger_types = {
            'id': 'str',
            'connection_type': 'str',
            'technology_type': 'str',
            'technology_sub_type': 'str',
            'database_version': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'connection_type': 'connectionType',
            'technology_type': 'technologyType',
            'technology_sub_type': 'technologySubType',
            'database_version': 'databaseVersion'
        }
        self._id = None
        self._connection_type = None
        self._technology_type = None
        self._technology_sub_type = None
        self._database_version = None

    @property
    def id(self):
        """
        Gets the id of this TargetAssessmentConnection.
        The OCID of the resource being referenced.


        :return: The id of this TargetAssessmentConnection.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this TargetAssessmentConnection.
        The OCID of the resource being referenced.


        :param id: The id of this TargetAssessmentConnection.
        :type: str
        """
        self._id = id

    @property
    def connection_type(self):
        """
        Gets the connection_type of this TargetAssessmentConnection.
        Defines the type of connection. For example, ORACLE.

        Allowed values for this property are: "MYSQL", "ORACLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The connection_type of this TargetAssessmentConnection.
        :rtype: str
        """
        return self._connection_type

    @connection_type.setter
    def connection_type(self, connection_type):
        """
        Sets the connection_type of this TargetAssessmentConnection.
        Defines the type of connection. For example, ORACLE.


        :param connection_type: The connection_type of this TargetAssessmentConnection.
        :type: str
        """
        allowed_values = ["MYSQL", "ORACLE"]
        if not value_allowed_none_or_none_sentinel(connection_type, allowed_values):
            connection_type = 'UNKNOWN_ENUM_VALUE'
        self._connection_type = connection_type

    @property
    def technology_type(self):
        """
        Gets the technology_type of this TargetAssessmentConnection.
        The technology type.

        Allowed values for this property are: "OCI_AUTONOMOUS_DATABASE", "OCI_MYSQL", "ORACLE_DATABASE", "ORACLE_EXADATA", "AMAZON_RDS_ORACLE", "AMAZON_AURORA_MYSQL", "AMAZON_RDS_MYSQL", "AZURE_MYSQL", "GOOGLE_CLOUD_SQL_MYSQL", "MYSQL_SERVER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The technology_type of this TargetAssessmentConnection.
        :rtype: str
        """
        return self._technology_type

    @technology_type.setter
    def technology_type(self, technology_type):
        """
        Sets the technology_type of this TargetAssessmentConnection.
        The technology type.


        :param technology_type: The technology_type of this TargetAssessmentConnection.
        :type: str
        """
        allowed_values = ["OCI_AUTONOMOUS_DATABASE", "OCI_MYSQL", "ORACLE_DATABASE", "ORACLE_EXADATA", "AMAZON_RDS_ORACLE", "AMAZON_AURORA_MYSQL", "AMAZON_RDS_MYSQL", "AZURE_MYSQL", "GOOGLE_CLOUD_SQL_MYSQL", "MYSQL_SERVER"]
        if not value_allowed_none_or_none_sentinel(technology_type, allowed_values):
            technology_type = 'UNKNOWN_ENUM_VALUE'
        self._technology_type = technology_type

    @property
    def technology_sub_type(self):
        """
        Gets the technology_sub_type of this TargetAssessmentConnection.
        Technology sub-type e.g. ADW_SHARED, ADW_DEDICATED, ATP_SHARED, ATP_DEDICATED


        :return: The technology_sub_type of this TargetAssessmentConnection.
        :rtype: str
        """
        return self._technology_sub_type

    @technology_sub_type.setter
    def technology_sub_type(self, technology_sub_type):
        """
        Sets the technology_sub_type of this TargetAssessmentConnection.
        Technology sub-type e.g. ADW_SHARED, ADW_DEDICATED, ATP_SHARED, ATP_DEDICATED


        :param technology_sub_type: The technology_sub_type of this TargetAssessmentConnection.
        :type: str
        """
        self._technology_sub_type = technology_sub_type

    @property
    def database_version(self):
        """
        Gets the database_version of this TargetAssessmentConnection.
        The database version


        :return: The database_version of this TargetAssessmentConnection.
        :rtype: str
        """
        return self._database_version

    @database_version.setter
    def database_version(self, database_version):
        """
        Sets the database_version of this TargetAssessmentConnection.
        The database version


        :param database_version: The database_version of this TargetAssessmentConnection.
        :type: str
        """
        self._database_version = database_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
