# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UserDefinedProperties(object):
    """
    User defined properties
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UserDefinedProperties object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UserDefinedProperties.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UserDefinedProperties.
        :type description: str

        :param help_link_url:
            The value to assign to the help_link_url property of this UserDefinedProperties.
        :type help_link_url: str

        :param help_link_text:
            The value to assign to the help_link_text property of this UserDefinedProperties.
        :type help_link_text: str

        :param properties:
            The value to assign to the properties property of this UserDefinedProperties.
        :type properties: list[oci.database_migration.models.UserDefinedProperty]

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'help_link_url': 'str',
            'help_link_text': 'str',
            'properties': 'list[UserDefinedProperty]'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'help_link_url': 'helpLinkUrl',
            'help_link_text': 'helpLinkText',
            'properties': 'properties'
        }
        self._display_name = None
        self._description = None
        self._help_link_url = None
        self._help_link_text = None
        self._properties = None

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this UserDefinedProperties.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this UserDefinedProperties.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UserDefinedProperties.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this UserDefinedProperties.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UserDefinedProperties.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The description of this UserDefinedProperties.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UserDefinedProperties.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param description: The description of this UserDefinedProperties.
        :type: str
        """
        self._description = description

    @property
    def help_link_url(self):
        """
        Gets the help_link_url of this UserDefinedProperties.
        The Help URL.


        :return: The help_link_url of this UserDefinedProperties.
        :rtype: str
        """
        return self._help_link_url

    @help_link_url.setter
    def help_link_url(self, help_link_url):
        """
        Sets the help_link_url of this UserDefinedProperties.
        The Help URL.


        :param help_link_url: The help_link_url of this UserDefinedProperties.
        :type: str
        """
        self._help_link_url = help_link_url

    @property
    def help_link_text(self):
        """
        Gets the help_link_text of this UserDefinedProperties.
        The Help link text.


        :return: The help_link_text of this UserDefinedProperties.
        :rtype: str
        """
        return self._help_link_text

    @help_link_text.setter
    def help_link_text(self, help_link_text):
        """
        Sets the help_link_text of this UserDefinedProperties.
        The Help link text.


        :param help_link_text: The help_link_text of this UserDefinedProperties.
        :type: str
        """
        self._help_link_text = help_link_text

    @property
    def properties(self):
        """
        Gets the properties of this UserDefinedProperties.
        Array of user defined properties.


        :return: The properties of this UserDefinedProperties.
        :rtype: list[oci.database_migration.models.UserDefinedProperty]
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this UserDefinedProperties.
        Array of user defined properties.


        :param properties: The properties of this UserDefinedProperties.
        :type: list[oci.database_migration.models.UserDefinedProperty]
        """
        self._properties = properties

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
