# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201005

from .create_database_tools_identity_details import CreateDatabaseToolsIdentityDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails(CreateDatabaseToolsIdentityDetails):
    """
    Details for the new Database Tools identity for the Oracle Database resource principal identity type.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database_tools.models.CreateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails.type` attribute
        of this class is ``ORACLE_DATABASE_RESOURCE_PRINCIPAL`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this CreateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails.
            Allowed values for this property are: "ORACLE_DATABASE_RESOURCE_PRINCIPAL"
        :type type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails.
        :type display_name: str

        :param database_tools_connection_id:
            The value to assign to the database_tools_connection_id property of this CreateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails.
        :type database_tools_connection_id: str

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails.
        :type freeform_tags: dict(str, str)

        :param locks:
            The value to assign to the locks property of this CreateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails.
        :type locks: list[oci.database_tools.models.ResourceLock]

        :param credential_key:
            The value to assign to the credential_key property of this CreateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails.
        :type credential_key: str

        """
        self.swagger_types = {
            'type': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'database_tools_connection_id': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)',
            'locks': 'list[ResourceLock]',
            'credential_key': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'database_tools_connection_id': 'databaseToolsConnectionId',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags',
            'locks': 'locks',
            'credential_key': 'credentialKey'
        }
        self._type = None
        self._compartment_id = None
        self._display_name = None
        self._database_tools_connection_id = None
        self._defined_tags = None
        self._freeform_tags = None
        self._locks = None
        self._credential_key = None
        self._type = 'ORACLE_DATABASE_RESOURCE_PRINCIPAL'

    @property
    def credential_key(self):
        """
        **[Required]** Gets the credential_key of this CreateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails.
        The name of the credential object created in the Oracle Database.


        :return: The credential_key of this CreateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails.
        :rtype: str
        """
        return self._credential_key

    @credential_key.setter
    def credential_key(self, credential_key):
        """
        Sets the credential_key of this CreateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails.
        The name of the credential object created in the Oracle Database.


        :param credential_key: The credential_key of this CreateDatabaseToolsIdentityOracleDatabaseResourcePrincipalDetails.
        :type: str
        """
        self._credential_key = credential_key

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
