# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DblmPatchManagement(object):
    """
    Description of PatchManagement.
    """

    #: A constant which can be used with the lifecycle_state property of a DblmPatchManagement.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a DblmPatchManagement.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a DblmPatchManagement.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a DblmPatchManagement.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    def __init__(self, **kwargs):
        """
        Initializes a new DblmPatchManagement object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this DblmPatchManagement.
        :type compartment_id: str

        :param resources:
            The value to assign to the resources property of this DblmPatchManagement.
        :type resources: list[oci.dblm.models.ResourceInfo]

        :param message:
            The value to assign to the message property of this DblmPatchManagement.
        :type message: str

        :param time_enabled:
            The value to assign to the time_enabled property of this DblmPatchManagement.
        :type time_enabled: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DblmPatchManagement.
            Allowed values for this property are: "CREATING", "ACTIVE", "FAILED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param patch_operations_summary:
            The value to assign to the patch_operations_summary property of this DblmPatchManagement.
        :type patch_operations_summary: object

        :param images_patch_recommendation_summary:
            The value to assign to the images_patch_recommendation_summary property of this DblmPatchManagement.
        :type images_patch_recommendation_summary: object

        :param resources_patch_compliance_summary:
            The value to assign to the resources_patch_compliance_summary property of this DblmPatchManagement.
        :type resources_patch_compliance_summary: object

        :param freeform_tags:
            The value to assign to the freeform_tags property of this DblmPatchManagement.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this DblmPatchManagement.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this DblmPatchManagement.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'resources': 'list[ResourceInfo]',
            'message': 'str',
            'time_enabled': 'datetime',
            'lifecycle_state': 'str',
            'patch_operations_summary': 'object',
            'images_patch_recommendation_summary': 'object',
            'resources_patch_compliance_summary': 'object',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'resources': 'resources',
            'message': 'message',
            'time_enabled': 'timeEnabled',
            'lifecycle_state': 'lifecycleState',
            'patch_operations_summary': 'patchOperationsSummary',
            'images_patch_recommendation_summary': 'imagesPatchRecommendationSummary',
            'resources_patch_compliance_summary': 'resourcesPatchComplianceSummary',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._compartment_id = None
        self._resources = None
        self._message = None
        self._time_enabled = None
        self._lifecycle_state = None
        self._patch_operations_summary = None
        self._images_patch_recommendation_summary = None
        self._resources_patch_compliance_summary = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this DblmPatchManagement.
        Compartment Identifier


        :return: The compartment_id of this DblmPatchManagement.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DblmPatchManagement.
        Compartment Identifier


        :param compartment_id: The compartment_id of this DblmPatchManagement.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resources(self):
        """
        Gets the resources of this DblmPatchManagement.
        resources objects


        :return: The resources of this DblmPatchManagement.
        :rtype: list[oci.dblm.models.ResourceInfo]
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """
        Sets the resources of this DblmPatchManagement.
        resources objects


        :param resources: The resources of this DblmPatchManagement.
        :type: list[oci.dblm.models.ResourceInfo]
        """
        self._resources = resources

    @property
    def message(self):
        """
        Gets the message of this DblmPatchManagement.
        A message describing the status of the feature's state


        :return: The message of this DblmPatchManagement.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this DblmPatchManagement.
        A message describing the status of the feature's state


        :param message: The message of this DblmPatchManagement.
        :type: str
        """
        self._message = message

    @property
    def time_enabled(self):
        """
        Gets the time_enabled of this DblmPatchManagement.
        The time the Vulnerability was enabled. An RFC3339 formatted datetime string.


        :return: The time_enabled of this DblmPatchManagement.
        :rtype: datetime
        """
        return self._time_enabled

    @time_enabled.setter
    def time_enabled(self, time_enabled):
        """
        Sets the time_enabled of this DblmPatchManagement.
        The time the Vulnerability was enabled. An RFC3339 formatted datetime string.


        :param time_enabled: The time_enabled of this DblmPatchManagement.
        :type: datetime
        """
        self._time_enabled = time_enabled

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this DblmPatchManagement.
        The current state of the feature.

        Allowed values for this property are: "CREATING", "ACTIVE", "FAILED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this DblmPatchManagement.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DblmPatchManagement.
        The current state of the feature.


        :param lifecycle_state: The lifecycle_state of this DblmPatchManagement.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "FAILED", "NEEDS_ATTENTION"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def patch_operations_summary(self):
        """
        Gets the patch_operations_summary of this DblmPatchManagement.
        Summary of patch operations.


        :return: The patch_operations_summary of this DblmPatchManagement.
        :rtype: object
        """
        return self._patch_operations_summary

    @patch_operations_summary.setter
    def patch_operations_summary(self, patch_operations_summary):
        """
        Sets the patch_operations_summary of this DblmPatchManagement.
        Summary of patch operations.


        :param patch_operations_summary: The patch_operations_summary of this DblmPatchManagement.
        :type: object
        """
        self._patch_operations_summary = patch_operations_summary

    @property
    def images_patch_recommendation_summary(self):
        """
        Gets the images_patch_recommendation_summary of this DblmPatchManagement.
        Summary of image patches recommended to install.


        :return: The images_patch_recommendation_summary of this DblmPatchManagement.
        :rtype: object
        """
        return self._images_patch_recommendation_summary

    @images_patch_recommendation_summary.setter
    def images_patch_recommendation_summary(self, images_patch_recommendation_summary):
        """
        Sets the images_patch_recommendation_summary of this DblmPatchManagement.
        Summary of image patches recommended to install.


        :param images_patch_recommendation_summary: The images_patch_recommendation_summary of this DblmPatchManagement.
        :type: object
        """
        self._images_patch_recommendation_summary = images_patch_recommendation_summary

    @property
    def resources_patch_compliance_summary(self):
        """
        Gets the resources_patch_compliance_summary of this DblmPatchManagement.
        Summary of image patches to be compliant to install.


        :return: The resources_patch_compliance_summary of this DblmPatchManagement.
        :rtype: object
        """
        return self._resources_patch_compliance_summary

    @resources_patch_compliance_summary.setter
    def resources_patch_compliance_summary(self, resources_patch_compliance_summary):
        """
        Sets the resources_patch_compliance_summary of this DblmPatchManagement.
        Summary of image patches to be compliant to install.


        :param resources_patch_compliance_summary: The resources_patch_compliance_summary of this DblmPatchManagement.
        :type: object
        """
        self._resources_patch_compliance_summary = resources_patch_compliance_summary

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this DblmPatchManagement.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this DblmPatchManagement.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this DblmPatchManagement.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this DblmPatchManagement.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this DblmPatchManagement.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this DblmPatchManagement.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this DblmPatchManagement.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this DblmPatchManagement.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this DblmPatchManagement.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this DblmPatchManagement.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this DblmPatchManagement.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this DblmPatchManagement.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
