# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RefreshOracleDbGcpKeyRingDetails(object):
    """
    Details for to refresh Oracle DB GCP Key Ring resource.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RefreshOracleDbGcpKeyRingDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param oracle_db_gcp_connector_id:
            The value to assign to the oracle_db_gcp_connector_id property of this RefreshOracleDbGcpKeyRingDetails.
        :type oracle_db_gcp_connector_id: str

        """
        self.swagger_types = {
            'oracle_db_gcp_connector_id': 'str'
        }
        self.attribute_map = {
            'oracle_db_gcp_connector_id': 'oracleDbGcpConnectorId'
        }
        self._oracle_db_gcp_connector_id = None

    @property
    def oracle_db_gcp_connector_id(self):
        """
        Gets the oracle_db_gcp_connector_id of this RefreshOracleDbGcpKeyRingDetails.
        The `OCID`__ of the Oracle DB GCP Connector resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The oracle_db_gcp_connector_id of this RefreshOracleDbGcpKeyRingDetails.
        :rtype: str
        """
        return self._oracle_db_gcp_connector_id

    @oracle_db_gcp_connector_id.setter
    def oracle_db_gcp_connector_id(self, oracle_db_gcp_connector_id):
        """
        Sets the oracle_db_gcp_connector_id of this RefreshOracleDbGcpKeyRingDetails.
        The `OCID`__ of the Oracle DB GCP Connector resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param oracle_db_gcp_connector_id: The oracle_db_gcp_connector_id of this RefreshOracleDbGcpKeyRingDetails.
        :type: str
        """
        self._oracle_db_gcp_connector_id = oracle_db_gcp_connector_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
