# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230801


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DelegatedResourceAccessRequestAuditLogReport(object):
    """
    The audit log report details.
    """

    #: A constant which can be used with the audit_report_status property of a DelegatedResourceAccessRequestAuditLogReport.
    #: This constant has a value of "NOTAVAILABLE"
    AUDIT_REPORT_STATUS_NOTAVAILABLE = "NOTAVAILABLE"

    #: A constant which can be used with the audit_report_status property of a DelegatedResourceAccessRequestAuditLogReport.
    #: This constant has a value of "AVAILABLE"
    AUDIT_REPORT_STATUS_AVAILABLE = "AVAILABLE"

    #: A constant which can be used with the audit_report_status property of a DelegatedResourceAccessRequestAuditLogReport.
    #: This constant has a value of "EXPIRED"
    AUDIT_REPORT_STATUS_EXPIRED = "EXPIRED"

    #: A constant which can be used with the audit_report_status property of a DelegatedResourceAccessRequestAuditLogReport.
    #: This constant has a value of "FAILED"
    AUDIT_REPORT_STATUS_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new DelegatedResourceAccessRequestAuditLogReport object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param report:
            The value to assign to the report property of this DelegatedResourceAccessRequestAuditLogReport.
        :type report: str

        :param process_tree:
            The value to assign to the process_tree property of this DelegatedResourceAccessRequestAuditLogReport.
        :type process_tree: str

        :param audit_report_status:
            The value to assign to the audit_report_status property of this DelegatedResourceAccessRequestAuditLogReport.
            Allowed values for this property are: "NOTAVAILABLE", "AVAILABLE", "EXPIRED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type audit_report_status: str

        :param time_report_generated:
            The value to assign to the time_report_generated property of this DelegatedResourceAccessRequestAuditLogReport.
        :type time_report_generated: datetime

        """
        self.swagger_types = {
            'report': 'str',
            'process_tree': 'str',
            'audit_report_status': 'str',
            'time_report_generated': 'datetime'
        }
        self.attribute_map = {
            'report': 'report',
            'process_tree': 'processTree',
            'audit_report_status': 'auditReportStatus',
            'time_report_generated': 'timeReportGenerated'
        }
        self._report = None
        self._process_tree = None
        self._audit_report_status = None
        self._time_report_generated = None

    @property
    def report(self):
        """
        Gets the report of this DelegatedResourceAccessRequestAuditLogReport.
        Audit log report.


        :return: The report of this DelegatedResourceAccessRequestAuditLogReport.
        :rtype: str
        """
        return self._report

    @report.setter
    def report(self, report):
        """
        Sets the report of this DelegatedResourceAccessRequestAuditLogReport.
        Audit log report.


        :param report: The report of this DelegatedResourceAccessRequestAuditLogReport.
        :type: str
        """
        self._report = report

    @property
    def process_tree(self):
        """
        Gets the process_tree of this DelegatedResourceAccessRequestAuditLogReport.
        The process tree data


        :return: The process_tree of this DelegatedResourceAccessRequestAuditLogReport.
        :rtype: str
        """
        return self._process_tree

    @process_tree.setter
    def process_tree(self, process_tree):
        """
        Sets the process_tree of this DelegatedResourceAccessRequestAuditLogReport.
        The process tree data


        :param process_tree: The process_tree of this DelegatedResourceAccessRequestAuditLogReport.
        :type: str
        """
        self._process_tree = process_tree

    @property
    def audit_report_status(self):
        """
        **[Required]** Gets the audit_report_status of this DelegatedResourceAccessRequestAuditLogReport.
        Status of the audit report

        Allowed values for this property are: "NOTAVAILABLE", "AVAILABLE", "EXPIRED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The audit_report_status of this DelegatedResourceAccessRequestAuditLogReport.
        :rtype: str
        """
        return self._audit_report_status

    @audit_report_status.setter
    def audit_report_status(self, audit_report_status):
        """
        Sets the audit_report_status of this DelegatedResourceAccessRequestAuditLogReport.
        Status of the audit report


        :param audit_report_status: The audit_report_status of this DelegatedResourceAccessRequestAuditLogReport.
        :type: str
        """
        allowed_values = ["NOTAVAILABLE", "AVAILABLE", "EXPIRED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(audit_report_status, allowed_values):
            audit_report_status = 'UNKNOWN_ENUM_VALUE'
        self._audit_report_status = audit_report_status

    @property
    def time_report_generated(self):
        """
        Gets the time_report_generated of this DelegatedResourceAccessRequestAuditLogReport.
        Time when the audit report was generated `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_report_generated of this DelegatedResourceAccessRequestAuditLogReport.
        :rtype: datetime
        """
        return self._time_report_generated

    @time_report_generated.setter
    def time_report_generated(self, time_report_generated):
        """
        Sets the time_report_generated of this DelegatedResourceAccessRequestAuditLogReport.
        Time when the audit report was generated `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_report_generated: The time_report_generated of this DelegatedResourceAccessRequestAuditLogReport.
        :type: datetime
        """
        self._time_report_generated = time_report_generated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
