# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CommitMessageSettings(object):
    """
    Settings for controlling how commit summaries are appended to the commit message when merging a pull request.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CommitMessageSettings object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param commit_summaries_count:
            The value to assign to the commit_summaries_count property of this CommitMessageSettings.
        :type commit_summaries_count: int

        """
        self.swagger_types = {
            'commit_summaries_count': 'int'
        }
        self.attribute_map = {
            'commit_summaries_count': 'commitSummariesCount'
        }
        self._commit_summaries_count = None

    @property
    def commit_summaries_count(self):
        """
        **[Required]** Gets the commit_summaries_count of this CommitMessageSettings.
        The number of commit summaries to append. Set to 0 to exclude commit summaries.


        :return: The commit_summaries_count of this CommitMessageSettings.
        :rtype: int
        """
        return self._commit_summaries_count

    @commit_summaries_count.setter
    def commit_summaries_count(self, commit_summaries_count):
        """
        Sets the commit_summaries_count of this CommitMessageSettings.
        The number of commit summaries to append. Set to 0 to exclude commit summaries.


        :param commit_summaries_count: The commit_summaries_count of this CommitMessageSettings.
        :type: int
        """
        self._commit_summaries_count = commit_summaries_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
