# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateReviewerDetails(object):
    """
    The reviewer to be updated.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateReviewerDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param principal_id:
            The value to assign to the principal_id property of this UpdateReviewerDetails.
        :type principal_id: str

        """
        self.swagger_types = {
            'principal_id': 'str'
        }
        self.attribute_map = {
            'principal_id': 'principalId'
        }
        self._principal_id = None

    @property
    def principal_id(self):
        """
        **[Required]** Gets the principal_id of this UpdateReviewerDetails.
        Pull Request reviewer id


        :return: The principal_id of this UpdateReviewerDetails.
        :rtype: str
        """
        return self._principal_id

    @principal_id.setter
    def principal_id(self, principal_id):
        """
        Sets the principal_id of this UpdateReviewerDetails.
        Pull Request reviewer id


        :param principal_id: The principal_id of this UpdateReviewerDetails.
        :type: str
        """
        self._principal_id = principal_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
