# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AiDataPlatformDetail(object):
    """
    AI Data Platform Details required to provision AIDP instance.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AiDataPlatformDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_id:
            The value to assign to the instance_id property of this AiDataPlatformDetail.
        :type instance_id: str

        :param default_workspace_name:
            The value to assign to the default_workspace_name property of this AiDataPlatformDetail.
        :type default_workspace_name: str

        """
        self.swagger_types = {
            'instance_id': 'str',
            'default_workspace_name': 'str'
        }
        self.attribute_map = {
            'instance_id': 'instanceId',
            'default_workspace_name': 'defaultWorkspaceName'
        }
        self._instance_id = None
        self._default_workspace_name = None

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this AiDataPlatformDetail.
        Identifier for AIDP instance to be provisioned.


        :return: The instance_id of this AiDataPlatformDetail.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this AiDataPlatformDetail.
        Identifier for AIDP instance to be provisioned.


        :param instance_id: The instance_id of this AiDataPlatformDetail.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def default_workspace_name(self):
        """
        **[Required]** Gets the default_workspace_name of this AiDataPlatformDetail.
        A default workspace will be created with this name.


        :return: The default_workspace_name of this AiDataPlatformDetail.
        :rtype: str
        """
        return self._default_workspace_name

    @default_workspace_name.setter
    def default_workspace_name(self, default_workspace_name):
        """
        Sets the default_workspace_name of this AiDataPlatformDetail.
        A default workspace will be created with this name.


        :param default_workspace_name: The default_workspace_name of this AiDataPlatformDetail.
        :type: str
        """
        self._default_workspace_name = default_workspace_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
