# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GenAiDetail(object):
    """
    GenAI details required to provision dedicated clusters.
    """

    #: A constant which can be used with the cluster_type property of a GenAiDetail.
    #: This constant has a value of "HOSTING"
    CLUSTER_TYPE_HOSTING = "HOSTING"

    def __init__(self, **kwargs):
        """
        Initializes a new GenAiDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_id:
            The value to assign to the instance_id property of this GenAiDetail.
        :type instance_id: str

        :param cluster_type:
            The value to assign to the cluster_type property of this GenAiDetail.
            Allowed values for this property are: "HOSTING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type cluster_type: str

        :param base_model:
            The value to assign to the base_model property of this GenAiDetail.
        :type base_model: str

        :param oci_region:
            The value to assign to the oci_region property of this GenAiDetail.
        :type oci_region: str

        :param unit_count:
            The value to assign to the unit_count property of this GenAiDetail.
        :type unit_count: int

        :param endpoints:
            The value to assign to the endpoints property of this GenAiDetail.
        :type endpoints: list[oci.dif.models.EndpointDetails]

        """
        self.swagger_types = {
            'instance_id': 'str',
            'cluster_type': 'str',
            'base_model': 'str',
            'oci_region': 'str',
            'unit_count': 'int',
            'endpoints': 'list[EndpointDetails]'
        }
        self.attribute_map = {
            'instance_id': 'instanceId',
            'cluster_type': 'clusterType',
            'base_model': 'baseModel',
            'oci_region': 'ociRegion',
            'unit_count': 'unitCount',
            'endpoints': 'endpoints'
        }
        self._instance_id = None
        self._cluster_type = None
        self._base_model = None
        self._oci_region = None
        self._unit_count = None
        self._endpoints = None

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this GenAiDetail.
        Id for the GenAi instance to be provisioned.


        :return: The instance_id of this GenAiDetail.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this GenAiDetail.
        Id for the GenAi instance to be provisioned.


        :param instance_id: The instance_id of this GenAiDetail.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def cluster_type(self):
        """
        **[Required]** Gets the cluster_type of this GenAiDetail.
        The dedicated AI cluster type.

        Allowed values for this property are: "HOSTING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The cluster_type of this GenAiDetail.
        :rtype: str
        """
        return self._cluster_type

    @cluster_type.setter
    def cluster_type(self, cluster_type):
        """
        Sets the cluster_type of this GenAiDetail.
        The dedicated AI cluster type.


        :param cluster_type: The cluster_type of this GenAiDetail.
        :type: str
        """
        allowed_values = ["HOSTING"]
        if not value_allowed_none_or_none_sentinel(cluster_type, allowed_values):
            cluster_type = 'UNKNOWN_ENUM_VALUE'
        self._cluster_type = cluster_type

    @property
    def base_model(self):
        """
        **[Required]** Gets the base_model of this GenAiDetail.
        Name of the base model.


        :return: The base_model of this GenAiDetail.
        :rtype: str
        """
        return self._base_model

    @base_model.setter
    def base_model(self, base_model):
        """
        Sets the base_model of this GenAiDetail.
        Name of the base model.


        :param base_model: The base_model of this GenAiDetail.
        :type: str
        """
        self._base_model = base_model

    @property
    def oci_region(self):
        """
        **[Required]** Gets the oci_region of this GenAiDetail.
        Region on which the cluster end endpoint will be provisioned.


        :return: The oci_region of this GenAiDetail.
        :rtype: str
        """
        return self._oci_region

    @oci_region.setter
    def oci_region(self, oci_region):
        """
        Sets the oci_region of this GenAiDetail.
        Region on which the cluster end endpoint will be provisioned.


        :param oci_region: The oci_region of this GenAiDetail.
        :type: str
        """
        self._oci_region = oci_region

    @property
    def unit_count(self):
        """
        **[Required]** Gets the unit_count of this GenAiDetail.
        No of replicas of base model to be used for hosting.


        :return: The unit_count of this GenAiDetail.
        :rtype: int
        """
        return self._unit_count

    @unit_count.setter
    def unit_count(self, unit_count):
        """
        Sets the unit_count of this GenAiDetail.
        No of replicas of base model to be used for hosting.


        :param unit_count: The unit_count of this GenAiDetail.
        :type: int
        """
        self._unit_count = unit_count

    @property
    def endpoints(self):
        """
        Gets the endpoints of this GenAiDetail.
        List of endpoints to provision for the GENAI cluster.


        :return: The endpoints of this GenAiDetail.
        :rtype: list[oci.dif.models.EndpointDetails]
        """
        return self._endpoints

    @endpoints.setter
    def endpoints(self, endpoints):
        """
        Sets the endpoints of this GenAiDetail.
        List of endpoints to provision for the GENAI cluster.


        :param endpoints: The endpoints of this GenAiDetail.
        :type: list[oci.dif.models.EndpointDetails]
        """
        self._endpoints = endpoints

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
