# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GgcsArtifactsDetail(object):
    """
    Details required to deploy artifacts in the GGCS deployment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GgcsArtifactsDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_id:
            The value to assign to the instance_id property of this GgcsArtifactsDetail.
        :type instance_id: str

        :param artifact_object_storage_path:
            The value to assign to the artifact_object_storage_path property of this GgcsArtifactsDetail.
        :type artifact_object_storage_path: str

        :param users:
            The value to assign to the users property of this GgcsArtifactsDetail.
        :type users: list[oci.dif.models.GgcsUserDetail]

        :param sources:
            The value to assign to the sources property of this GgcsArtifactsDetail.
        :type sources: list[oci.dif.models.GgcsSourceDetail]

        :param targets:
            The value to assign to the targets property of this GgcsArtifactsDetail.
        :type targets: list[oci.dif.models.GgcsTargetDetail]

        """
        self.swagger_types = {
            'instance_id': 'str',
            'artifact_object_storage_path': 'str',
            'users': 'list[GgcsUserDetail]',
            'sources': 'list[GgcsSourceDetail]',
            'targets': 'list[GgcsTargetDetail]'
        }
        self.attribute_map = {
            'instance_id': 'instanceId',
            'artifact_object_storage_path': 'artifactObjectStoragePath',
            'users': 'users',
            'sources': 'sources',
            'targets': 'targets'
        }
        self._instance_id = None
        self._artifact_object_storage_path = None
        self._users = None
        self._sources = None
        self._targets = None

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this GgcsArtifactsDetail.
        Instance id of the exisitng GGCS instance.


        :return: The instance_id of this GgcsArtifactsDetail.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this GgcsArtifactsDetail.
        Instance id of the exisitng GGCS instance.


        :param instance_id: The instance_id of this GgcsArtifactsDetail.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def artifact_object_storage_path(self):
        """
        Gets the artifact_object_storage_path of this GgcsArtifactsDetail.
        Object storage root path containing GGCS artifacts.


        :return: The artifact_object_storage_path of this GgcsArtifactsDetail.
        :rtype: str
        """
        return self._artifact_object_storage_path

    @artifact_object_storage_path.setter
    def artifact_object_storage_path(self, artifact_object_storage_path):
        """
        Sets the artifact_object_storage_path of this GgcsArtifactsDetail.
        Object storage root path containing GGCS artifacts.


        :param artifact_object_storage_path: The artifact_object_storage_path of this GgcsArtifactsDetail.
        :type: str
        """
        self._artifact_object_storage_path = artifact_object_storage_path

    @property
    def users(self):
        """
        Gets the users of this GgcsArtifactsDetail.
        Ggcs user details to be created or updated.


        :return: The users of this GgcsArtifactsDetail.
        :rtype: list[oci.dif.models.GgcsUserDetail]
        """
        return self._users

    @users.setter
    def users(self, users):
        """
        Sets the users of this GgcsArtifactsDetail.
        Ggcs user details to be created or updated.


        :param users: The users of this GgcsArtifactsDetail.
        :type: list[oci.dif.models.GgcsUserDetail]
        """
        self._users = users

    @property
    def sources(self):
        """
        Gets the sources of this GgcsArtifactsDetail.
        Source Detail to configure existing or new datasource.


        :return: The sources of this GgcsArtifactsDetail.
        :rtype: list[oci.dif.models.GgcsSourceDetail]
        """
        return self._sources

    @sources.setter
    def sources(self, sources):
        """
        Sets the sources of this GgcsArtifactsDetail.
        Source Detail to configure existing or new datasource.


        :param sources: The sources of this GgcsArtifactsDetail.
        :type: list[oci.dif.models.GgcsSourceDetail]
        """
        self._sources = sources

    @property
    def targets(self):
        """
        Gets the targets of this GgcsArtifactsDetail.
        Target Detail to configure existing or new datasource.


        :return: The targets of this GgcsArtifactsDetail.
        :rtype: list[oci.dif.models.GgcsTargetDetail]
        """
        return self._targets

    @targets.setter
    def targets(self, targets):
        """
        Sets the targets of this GgcsArtifactsDetail.
        Target Detail to configure existing or new datasource.


        :param targets: The targets of this GgcsArtifactsDetail.
        :type: list[oci.dif.models.GgcsTargetDetail]
        """
        self._targets = targets

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
