# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GgcsTargetDetail(object):
    """
    GGCS target configuration for creating or updating existing replicats.
    """

    #: A constant which can be used with the action property of a GgcsTargetDetail.
    #: This constant has a value of "CREATE"
    ACTION_CREATE = "CREATE"

    #: A constant which can be used with the action property of a GgcsTargetDetail.
    #: This constant has a value of "UPDATE"
    ACTION_UPDATE = "UPDATE"

    def __init__(self, **kwargs):
        """
        Initializes a new GgcsTargetDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param target_id:
            The value to assign to the target_id property of this GgcsTargetDetail.
        :type target_id: str

        :param action:
            The value to assign to the action property of this GgcsTargetDetail.
            Allowed values for this property are: "CREATE", "UPDATE"
        :type action: str

        :param should_start_target_operations:
            The value to assign to the should_start_target_operations property of this GgcsTargetDetail.
        :type should_start_target_operations: bool

        :param source_uri:
            The value to assign to the source_uri property of this GgcsTargetDetail.
        :type source_uri: str

        :param source_connection_name:
            The value to assign to the source_connection_name property of this GgcsTargetDetail.
        :type source_connection_name: str

        """
        self.swagger_types = {
            'target_id': 'str',
            'action': 'str',
            'should_start_target_operations': 'bool',
            'source_uri': 'str',
            'source_connection_name': 'str'
        }
        self.attribute_map = {
            'target_id': 'targetId',
            'action': 'action',
            'should_start_target_operations': 'shouldStartTargetOperations',
            'source_uri': 'sourceUri',
            'source_connection_name': 'sourceConnectionName'
        }
        self._target_id = None
        self._action = None
        self._should_start_target_operations = None
        self._source_uri = None
        self._source_connection_name = None

    @property
    def target_id(self):
        """
        **[Required]** Gets the target_id of this GgcsTargetDetail.
        GGCS target artifact id.


        :return: The target_id of this GgcsTargetDetail.
        :rtype: str
        """
        return self._target_id

    @target_id.setter
    def target_id(self, target_id):
        """
        Sets the target_id of this GgcsTargetDetail.
        GGCS target artifact id.


        :param target_id: The target_id of this GgcsTargetDetail.
        :type: str
        """
        self._target_id = target_id

    @property
    def action(self):
        """
        **[Required]** Gets the action of this GgcsTargetDetail.
        Action to be done over the user. Allowed values are \"CREATE\" or \"UPDATE\".

        Allowed values for this property are: "CREATE", "UPDATE"


        :return: The action of this GgcsTargetDetail.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this GgcsTargetDetail.
        Action to be done over the user. Allowed values are \"CREATE\" or \"UPDATE\".


        :param action: The action of this GgcsTargetDetail.
        :type: str
        """
        allowed_values = ["CREATE", "UPDATE"]
        if not value_allowed_none_or_none_sentinel(action, allowed_values):
            raise ValueError(
                f"Invalid value for `action`, must be None or one of {allowed_values}"
            )
        self._action = action

    @property
    def should_start_target_operations(self):
        """
        **[Required]** Gets the should_start_target_operations of this GgcsTargetDetail.
        Boolean value that determines target operations should start or not.


        :return: The should_start_target_operations of this GgcsTargetDetail.
        :rtype: bool
        """
        return self._should_start_target_operations

    @should_start_target_operations.setter
    def should_start_target_operations(self, should_start_target_operations):
        """
        Sets the should_start_target_operations of this GgcsTargetDetail.
        Boolean value that determines target operations should start or not.


        :param should_start_target_operations: The should_start_target_operations of this GgcsTargetDetail.
        :type: bool
        """
        self._should_start_target_operations = should_start_target_operations

    @property
    def source_uri(self):
        """
        Gets the source_uri of this GgcsTargetDetail.
        Source uri for the GoldenGate deployment from where the collector path needs to be configured.


        :return: The source_uri of this GgcsTargetDetail.
        :rtype: str
        """
        return self._source_uri

    @source_uri.setter
    def source_uri(self, source_uri):
        """
        Sets the source_uri of this GgcsTargetDetail.
        Source uri for the GoldenGate deployment from where the collector path needs to be configured.


        :param source_uri: The source_uri of this GgcsTargetDetail.
        :type: str
        """
        self._source_uri = source_uri

    @property
    def source_connection_name(self):
        """
        Gets the source_connection_name of this GgcsTargetDetail.
        Name of assigned connection for the target.


        :return: The source_connection_name of this GgcsTargetDetail.
        :rtype: str
        """
        return self._source_connection_name

    @source_connection_name.setter
    def source_connection_name(self, source_connection_name):
        """
        Sets the source_connection_name of this GgcsTargetDetail.
        Name of assigned connection for the target.


        :param source_connection_name: The source_connection_name of this GgcsTargetDetail.
        :type: str
        """
        self._source_connection_name = source_connection_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
