# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OmkArtifactsDetail(object):
    """
    Detail to deploy artifacts for OMK service.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OmkArtifactsDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_id:
            The value to assign to the instance_id property of this OmkArtifactsDetail.
        :type instance_id: str

        :param secrets:
            The value to assign to the secrets property of this OmkArtifactsDetail.
        :type secrets: list[oci.dif.models.SecretDetail]

        :param manifest_object_storage_path:
            The value to assign to the manifest_object_storage_path property of this OmkArtifactsDetail.
        :type manifest_object_storage_path: str

        :param component_value_overrides:
            The value to assign to the component_value_overrides property of this OmkArtifactsDetail.
        :type component_value_overrides: list[oci.dif.models.ComponentValueOverride]

        """
        self.swagger_types = {
            'instance_id': 'str',
            'secrets': 'list[SecretDetail]',
            'manifest_object_storage_path': 'str',
            'component_value_overrides': 'list[ComponentValueOverride]'
        }
        self.attribute_map = {
            'instance_id': 'instanceId',
            'secrets': 'secrets',
            'manifest_object_storage_path': 'manifestObjectStoragePath',
            'component_value_overrides': 'componentValueOverrides'
        }
        self._instance_id = None
        self._secrets = None
        self._manifest_object_storage_path = None
        self._component_value_overrides = None

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this OmkArtifactsDetail.
        Instance id of the existing OMK instance for artifact deployment.


        :return: The instance_id of this OmkArtifactsDetail.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this OmkArtifactsDetail.
        Instance id of the existing OMK instance for artifact deployment.


        :param instance_id: The instance_id of this OmkArtifactsDetail.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def secrets(self):
        """
        Gets the secrets of this OmkArtifactsDetail.
        List of kubernetes secrets to create or update in the namespace-name of target cluster-namespace. Each entry source secret values from OCI vault.


        :return: The secrets of this OmkArtifactsDetail.
        :rtype: list[oci.dif.models.SecretDetail]
        """
        return self._secrets

    @secrets.setter
    def secrets(self, secrets):
        """
        Sets the secrets of this OmkArtifactsDetail.
        List of kubernetes secrets to create or update in the namespace-name of target cluster-namespace. Each entry source secret values from OCI vault.


        :param secrets: The secrets of this OmkArtifactsDetail.
        :type: list[oci.dif.models.SecretDetail]
        """
        self._secrets = secrets

    @property
    def manifest_object_storage_path(self):
        """
        Gets the manifest_object_storage_path of this OmkArtifactsDetail.
        Object storage path for the deployment manifest.


        :return: The manifest_object_storage_path of this OmkArtifactsDetail.
        :rtype: str
        """
        return self._manifest_object_storage_path

    @manifest_object_storage_path.setter
    def manifest_object_storage_path(self, manifest_object_storage_path):
        """
        Sets the manifest_object_storage_path of this OmkArtifactsDetail.
        Object storage path for the deployment manifest.


        :param manifest_object_storage_path: The manifest_object_storage_path of this OmkArtifactsDetail.
        :type: str
        """
        self._manifest_object_storage_path = manifest_object_storage_path

    @property
    def component_value_overrides(self):
        """
        Gets the component_value_overrides of this OmkArtifactsDetail.
        Component overrides for stack specific parameters applied during artifact template rendering.


        :return: The component_value_overrides of this OmkArtifactsDetail.
        :rtype: list[oci.dif.models.ComponentValueOverride]
        """
        return self._component_value_overrides

    @component_value_overrides.setter
    def component_value_overrides(self, component_value_overrides):
        """
        Sets the component_value_overrides of this OmkArtifactsDetail.
        Component overrides for stack specific parameters applied during artifact template rendering.


        :param component_value_overrides: The component_value_overrides of this OmkArtifactsDetail.
        :type: list[oci.dif.models.ComponentValueOverride]
        """
        self._component_value_overrides = component_value_overrides

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
