# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220926


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Sender(object):
    """
    The envelope and the header from email address details, that is sending the email. Email address must be an approved sender.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Sender object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param sender_address:
            The value to assign to the sender_address property of this Sender.
        :type sender_address: oci.email_data_plane.models.EmailAddress

        :param compartment_id:
            The value to assign to the compartment_id property of this Sender.
        :type compartment_id: str

        """
        self.swagger_types = {
            'sender_address': 'EmailAddress',
            'compartment_id': 'str'
        }
        self.attribute_map = {
            'sender_address': 'senderAddress',
            'compartment_id': 'compartmentId'
        }
        self._sender_address = None
        self._compartment_id = None

    @property
    def sender_address(self):
        """
        **[Required]** Gets the sender_address of this Sender.

        :return: The sender_address of this Sender.
        :rtype: oci.email_data_plane.models.EmailAddress
        """
        return self._sender_address

    @sender_address.setter
    def sender_address(self, sender_address):
        """
        Sets the sender_address of this Sender.

        :param sender_address: The sender_address of this Sender.
        :type: oci.email_data_plane.models.EmailAddress
        """
        self._sender_address = sender_address

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this Sender.
        The `OCID`__ of the compartment that contains the approved sender resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this Sender.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this Sender.
        The `OCID`__ of the compartment that contains the approved sender resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this Sender.
        :type: str
        """
        self._compartment_id = compartment_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
