# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20171215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ScheduleDowngradeShapeMountTargetDetails(object):
    """
    Shape details about the Mount Target.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ScheduleDowngradeShapeMountTargetDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param requested_throughput:
            The value to assign to the requested_throughput property of this ScheduleDowngradeShapeMountTargetDetails.
        :type requested_throughput: int

        """
        self.swagger_types = {
            'requested_throughput': 'int'
        }
        self.attribute_map = {
            'requested_throughput': 'requestedThroughput'
        }
        self._requested_throughput = None

    @property
    def requested_throughput(self):
        """
        Gets the requested_throughput of this ScheduleDowngradeShapeMountTargetDetails.
        New throughput for mount target in Gbps. Available shapes and corresponding throughput are listed at
        `Mount Target Performance`__.

        __ https://docs.oracle.com/iaas/Content/File/Tasks/managingmounttargets.htm#performance


        :return: The requested_throughput of this ScheduleDowngradeShapeMountTargetDetails.
        :rtype: int
        """
        return self._requested_throughput

    @requested_throughput.setter
    def requested_throughput(self, requested_throughput):
        """
        Sets the requested_throughput of this ScheduleDowngradeShapeMountTargetDetails.
        New throughput for mount target in Gbps. Available shapes and corresponding throughput are listed at
        `Mount Target Performance`__.

        __ https://docs.oracle.com/iaas/Content/File/Tasks/managingmounttargets.htm#performance


        :param requested_throughput: The requested_throughput of this ScheduleDowngradeShapeMountTargetDetails.
        :type: int
        """
        self._requested_throughput = requested_throughput

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
