# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BaseVariable(object):
    """
    Base definition for a schema variable, including common metadata such as type, title, description, and validation constraints.
    """

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "ARRAY"
    TYPE_ARRAY = "ARRAY"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "BOOLEAN"
    TYPE_BOOLEAN = "BOOLEAN"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "ENUM"
    TYPE_ENUM = "ENUM"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "INTEGER"
    TYPE_INTEGER = "INTEGER"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "NUMBER"
    TYPE_NUMBER = "NUMBER"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "STRING"
    TYPE_STRING = "STRING"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "TEXT"
    TYPE_TEXT = "TEXT"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "FILE"
    TYPE_FILE = "FILE"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "PASSWORD"
    TYPE_PASSWORD = "PASSWORD"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "DATETIME"
    TYPE_DATETIME = "DATETIME"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "DUMMY"
    TYPE_DUMMY = "DUMMY"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_IDENTITY_DOMAINS_ID"
    TYPE_OCI_IDENTITY_DOMAINS_ID = "OCI_IDENTITY_DOMAINS_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_CORE_IMAGE_ID"
    TYPE_OCI_CORE_IMAGE_ID = "OCI_CORE_IMAGE_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_CORE_INSTANCESHAPEWITHFLEX_NAME"
    TYPE_OCI_CORE_INSTANCESHAPEWITHFLEX_NAME = "OCI_CORE_INSTANCESHAPEWITHFLEX_NAME"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_CORE_INSTANCESHAPE_NAME"
    TYPE_OCI_CORE_INSTANCESHAPE_NAME = "OCI_CORE_INSTANCESHAPE_NAME"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_CORE_NATGATEWAY_ID"
    TYPE_OCI_CORE_NATGATEWAY_ID = "OCI_CORE_NATGATEWAY_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_CORE_INSTANCE_ID"
    TYPE_OCI_CORE_INSTANCE_ID = "OCI_CORE_INSTANCE_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_CORE_SUBNET_ID"
    TYPE_OCI_CORE_SUBNET_ID = "OCI_CORE_SUBNET_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_CORE_SERVICEGATEWAY_ID"
    TYPE_OCI_CORE_SERVICEGATEWAY_ID = "OCI_CORE_SERVICEGATEWAY_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_LOGAN_LOGGROUP_ID"
    TYPE_OCI_LOGAN_LOGGROUP_ID = "OCI_LOGAN_LOGGROUP_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_LOGAN_SCHEDULEDTASK_ID"
    TYPE_OCI_LOGAN_SCHEDULEDTASK_ID = "OCI_LOGAN_SCHEDULEDTASK_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_LOGAN_LOGENTITY_ID"
    TYPE_OCI_LOGAN_LOGENTITY_ID = "OCI_LOGAN_LOGENTITY_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_LOGAN_ENTITYTYPE_ID"
    TYPE_OCI_LOGAN_ENTITYTYPE_ID = "OCI_LOGAN_ENTITYTYPE_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_MGMT_AGENT_ID"
    TYPE_OCI_MGMT_AGENT_ID = "OCI_MGMT_AGENT_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_LOGAN_SOURCE_ID"
    TYPE_OCI_LOGAN_SOURCE_ID = "OCI_LOGAN_SOURCE_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_CORE_NSG_ID"
    TYPE_OCI_CORE_NSG_ID = "OCI_CORE_NSG_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_CORE_VCN_ID"
    TYPE_OCI_CORE_VCN_ID = "OCI_CORE_VCN_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_IDENTITY_AVAILABILITYDOMAIN_NAME"
    TYPE_OCI_IDENTITY_AVAILABILITYDOMAIN_NAME = "OCI_IDENTITY_AVAILABILITYDOMAIN_NAME"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_IDENTITY_COMPARTMENT_ID"
    TYPE_OCI_IDENTITY_COMPARTMENT_ID = "OCI_IDENTITY_COMPARTMENT_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_IDENTITY_FAULTDOMAIN_NAME"
    TYPE_OCI_IDENTITY_FAULTDOMAIN_NAME = "OCI_IDENTITY_FAULTDOMAIN_NAME"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_IDENTITY_REGION_NAME"
    TYPE_OCI_IDENTITY_REGION_NAME = "OCI_IDENTITY_REGION_NAME"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_DATABASE_DBSYSTEM_ID"
    TYPE_OCI_DATABASE_DBSYSTEM_ID = "OCI_DATABASE_DBSYSTEM_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_DATABASE_DBHOME_ID"
    TYPE_OCI_DATABASE_DBHOME_ID = "OCI_DATABASE_DBHOME_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_DATABASE_DBHOME_DBVERSION"
    TYPE_OCI_DATABASE_DBHOME_DBVERSION = "OCI_DATABASE_DBHOME_DBVERSION"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_DATABASE_DATABASE_ID"
    TYPE_OCI_DATABASE_DATABASE_ID = "OCI_DATABASE_DATABASE_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_DATABASE_AUTONOMOUSDATABASE_ID"
    TYPE_OCI_DATABASE_AUTONOMOUSDATABASE_ID = "OCI_DATABASE_AUTONOMOUSDATABASE_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_DATABASE_AUTONOMOUSDATABASEVERSION_ID"
    TYPE_OCI_DATABASE_AUTONOMOUSDATABASEVERSION_ID = "OCI_DATABASE_AUTONOMOUSDATABASEVERSION_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_DATABASE_AUTONOMOUSCONTAINERDATABASE_ID"
    TYPE_OCI_DATABASE_AUTONOMOUSCONTAINERDATABASE_ID = "OCI_DATABASE_AUTONOMOUSCONTAINERDATABASE_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_KMS_KEY_ID"
    TYPE_OCI_KMS_KEY_ID = "OCI_KMS_KEY_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_KMS_SECRET_ID"
    TYPE_OCI_KMS_SECRET_ID = "OCI_KMS_SECRET_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_CONTAINER_CLUSTER_ID"
    TYPE_OCI_CONTAINER_CLUSTER_ID = "OCI_CONTAINER_CLUSTER_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_KUBERNETES_VERSIONS_ID"
    TYPE_OCI_KUBERNETES_VERSIONS_ID = "OCI_KUBERNETES_VERSIONS_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_BLOCKSTORAGE_POLICIES_ID"
    TYPE_OCI_BLOCKSTORAGE_POLICIES_ID = "OCI_BLOCKSTORAGE_POLICIES_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_IDENTITY_GROUPS_ID"
    TYPE_OCI_IDENTITY_GROUPS_ID = "OCI_IDENTITY_GROUPS_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_IDENTITY_DYNAMICGROUPS_ID"
    TYPE_OCI_IDENTITY_DYNAMICGROUPS_ID = "OCI_IDENTITY_DYNAMICGROUPS_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_LOADBALANCER_LOADBALANCER_ID"
    TYPE_OCI_LOADBALANCER_LOADBALANCER_ID = "OCI_LOADBALANCER_LOADBALANCER_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_MOUNT_TARGET_ID"
    TYPE_OCI_MOUNT_TARGET_ID = "OCI_MOUNT_TARGET_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_IDENTITY_TAG_VALUE"
    TYPE_OCI_IDENTITY_TAG_VALUE = "OCI_IDENTITY_TAG_VALUE"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_ODS_PROJECT_ID"
    TYPE_OCI_ODS_PROJECT_ID = "OCI_ODS_PROJECT_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_RESOURCEMANAGER_PRIVATEENDPOINT_ID"
    TYPE_OCI_RESOURCEMANAGER_PRIVATEENDPOINT_ID = "OCI_RESOURCEMANAGER_PRIVATEENDPOINT_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_APM_DOMAIN_ID"
    TYPE_OCI_APM_DOMAIN_ID = "OCI_APM_DOMAIN_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_CORE_SSH_PUBLICKEY"
    TYPE_OCI_CORE_SSH_PUBLICKEY = "OCI_CORE_SSH_PUBLICKEY"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_KMS_VAULT_ID"
    TYPE_OCI_KMS_VAULT_ID = "OCI_KMS_VAULT_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_LOADBALANCER_NETWORKLOADBALANCER_ID"
    TYPE_OCI_LOADBALANCER_NETWORKLOADBALANCER_ID = "OCI_LOADBALANCER_NETWORKLOADBALANCER_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_LOADBALANCER_LOADBALANCER_RESERVEDIPS_ID"
    TYPE_OCI_LOADBALANCER_LOADBALANCER_RESERVEDIPS_ID = "OCI_LOADBALANCER_LOADBALANCER_RESERVEDIPS_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_DATABASE_MYSQL_SHAPE_ID"
    TYPE_OCI_DATABASE_MYSQL_SHAPE_ID = "OCI_DATABASE_MYSQL_SHAPE_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_DATABASE_MYSQL_CONFIGURATION_ID"
    TYPE_OCI_DATABASE_MYSQL_CONFIGURATION_ID = "OCI_DATABASE_MYSQL_CONFIGURATION_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_STORAGE_FILESTORAGE_EXPORTSET_ID"
    TYPE_OCI_STORAGE_FILESTORAGE_EXPORTSET_ID = "OCI_STORAGE_FILESTORAGE_EXPORTSET_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_STORAGE_FILESTORAGE_FILESYSTEM_ID"
    TYPE_OCI_STORAGE_FILESTORAGE_FILESYSTEM_ID = "OCI_STORAGE_FILESTORAGE_FILESYSTEM_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_STORAGE_OBJECTSTORAGE_BUCKET_NAME"
    TYPE_OCI_STORAGE_OBJECTSTORAGE_BUCKET_NAME = "OCI_STORAGE_OBJECTSTORAGE_BUCKET_NAME"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_CORE_VCN_SECLIST_ID"
    TYPE_OCI_CORE_VCN_SECLIST_ID = "OCI_CORE_VCN_SECLIST_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_CORE_VOLUME_ID"
    TYPE_OCI_CORE_VOLUME_ID = "OCI_CORE_VOLUME_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_DATABASE_DATAGUARD_ID"
    TYPE_OCI_DATABASE_DATAGUARD_ID = "OCI_DATABASE_DATAGUARD_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_DATABASE_EXADATA_ID"
    TYPE_OCI_DATABASE_EXADATA_ID = "OCI_DATABASE_EXADATA_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_DATABASE_CLOUDVMCLUSTER_ID"
    TYPE_OCI_DATABASE_CLOUDVMCLUSTER_ID = "OCI_DATABASE_CLOUDVMCLUSTER_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_DATABASE_CDB_ID"
    TYPE_OCI_DATABASE_CDB_ID = "OCI_DATABASE_CDB_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_DATABASE_DATAGUARDASSOCIATION_ID"
    TYPE_OCI_DATABASE_DATAGUARDASSOCIATION_ID = "OCI_DATABASE_DATAGUARDASSOCIATION_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_DATABASE_DBNODE_ID"
    TYPE_OCI_DATABASE_DBNODE_ID = "OCI_DATABASE_DBNODE_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_CORE_VCN_NETWORKSECURITYGROUP_ID"
    TYPE_OCI_CORE_VCN_NETWORKSECURITYGROUP_ID = "OCI_CORE_VCN_NETWORKSECURITYGROUP_ID"

    #: A constant which can be used with the type property of a BaseVariable.
    #: This constant has a value of "OCI_STORAGE_FILESTORAGE_MOUNTTARGET_ID"
    TYPE_OCI_STORAGE_FILESTORAGE_MOUNTTARGET_ID = "OCI_STORAGE_FILESTORAGE_MOUNTTARGET_ID"

    def __init__(self, **kwargs):
        """
        Initializes a new BaseVariable object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_apps_management.models.NetworkLoadBalancerId`
        * :class:`~oci.fleet_apps_management.models.FileVariable`
        * :class:`~oci.fleet_apps_management.models.NatGatewayVariable`
        * :class:`~oci.fleet_apps_management.models.EnumVariable`
        * :class:`~oci.fleet_apps_management.models.InstanceShapeVariable`
        * :class:`~oci.fleet_apps_management.models.AutonomousContainerDbVariable`
        * :class:`~oci.fleet_apps_management.models.DataBaseVariable`
        * :class:`~oci.fleet_apps_management.models.AutonomousDatabaseVersionVariable`
        * :class:`~oci.fleet_apps_management.models.RegionVariable`
        * :class:`~oci.fleet_apps_management.models.VolumeId`
        * :class:`~oci.fleet_apps_management.models.VcnNetworkSecurityGroupId`
        * :class:`~oci.fleet_apps_management.models.IntegerVariable`
        * :class:`~oci.fleet_apps_management.models.DatabaseDbNodeId`
        * :class:`~oci.fleet_apps_management.models.MultilineVariable`
        * :class:`~oci.fleet_apps_management.models.PasswordVariable`
        * :class:`~oci.fleet_apps_management.models.ArrayVariable`
        * :class:`~oci.fleet_apps_management.models.ManagementAgents`
        * :class:`~oci.fleet_apps_management.models.VolumeBackupPoliciesVariable`
        * :class:`~oci.fleet_apps_management.models.LogAnalyticsScheduledTasks`
        * :class:`~oci.fleet_apps_management.models.KmsVaultVariable`
        * :class:`~oci.fleet_apps_management.models.ServiceGatewayVariable`
        * :class:`~oci.fleet_apps_management.models.LogAnalyticsLogEntities`
        * :class:`~oci.fleet_apps_management.models.VcnSecListId`
        * :class:`~oci.fleet_apps_management.models.NsgVariable`
        * :class:`~oci.fleet_apps_management.models.DynamicGroupsVariable`
        * :class:`~oci.fleet_apps_management.models.OdsProjectVariable`
        * :class:`~oci.fleet_apps_management.models.MountTargetsVariable`
        * :class:`~oci.fleet_apps_management.models.IdentityDomainVariable`
        * :class:`~oci.fleet_apps_management.models.ObjectStorageBucketName`
        * :class:`~oci.fleet_apps_management.models.MysqlConfigurationId`
        * :class:`~oci.fleet_apps_management.models.FileStorageExportSetId`
        * :class:`~oci.fleet_apps_management.models.KmsSecretVariable`
        * :class:`~oci.fleet_apps_management.models.DatetimeVariable`
        * :class:`~oci.fleet_apps_management.models.DatabaseDataguardAssociationId`
        * :class:`~oci.fleet_apps_management.models.LogAnalyticsEntityTypes`
        * :class:`~oci.fleet_apps_management.models.GroupsVariable`
        * :class:`~oci.fleet_apps_management.models.ApmDomainVariable`
        * :class:`~oci.fleet_apps_management.models.AutonomousDataBaseVariable`
        * :class:`~oci.fleet_apps_management.models.AvailabilityDomainVariable`
        * :class:`~oci.fleet_apps_management.models.KubernetesVersionsVariable`
        * :class:`~oci.fleet_apps_management.models.LoadBalancerVariable`
        * :class:`~oci.fleet_apps_management.models.ImageVariable`
        * :class:`~oci.fleet_apps_management.models.LoadBalancerReservedIps`
        * :class:`~oci.fleet_apps_management.models.KmsKeyVariable`
        * :class:`~oci.fleet_apps_management.models.LogAnalyticsSources`
        * :class:`~oci.fleet_apps_management.models.DatabaseDataGuardId`
        * :class:`~oci.fleet_apps_management.models.TagVariable`
        * :class:`~oci.fleet_apps_management.models.CloudVmClusterId`
        * :class:`~oci.fleet_apps_management.models.PrivateEndpointVariable`
        * :class:`~oci.fleet_apps_management.models.ContainerClusterVariable`
        * :class:`~oci.fleet_apps_management.models.MysqlShapeId`
        * :class:`~oci.fleet_apps_management.models.VcnVariable`
        * :class:`~oci.fleet_apps_management.models.CompartmentVariable`
        * :class:`~oci.fleet_apps_management.models.FaultDomainVariable`
        * :class:`~oci.fleet_apps_management.models.InstanceShapeVariableWithFlex`
        * :class:`~oci.fleet_apps_management.models.StringVariable`
        * :class:`~oci.fleet_apps_management.models.InstanceVariable`
        * :class:`~oci.fleet_apps_management.models.DatabaseExadataId`
        * :class:`~oci.fleet_apps_management.models.DbHomeVariable`
        * :class:`~oci.fleet_apps_management.models.FileStorageFilesystemId`
        * :class:`~oci.fleet_apps_management.models.NumberVariable`
        * :class:`~oci.fleet_apps_management.models.SubnetVariable`
        * :class:`~oci.fleet_apps_management.models.SshPublicKeyVariable`
        * :class:`~oci.fleet_apps_management.models.LogAnalyticsLogGroup`
        * :class:`~oci.fleet_apps_management.models.BooleanVariable`
        * :class:`~oci.fleet_apps_management.models.DbSystemVariable`
        * :class:`~oci.fleet_apps_management.models.FileStorageMountTargetId`
        * :class:`~oci.fleet_apps_management.models.DatabaseCdbId`
        * :class:`~oci.fleet_apps_management.models.DbHomeVersionVariable`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this BaseVariable.
            Allowed values for this property are: "ARRAY", "BOOLEAN", "ENUM", "INTEGER", "NUMBER", "STRING", "TEXT", "FILE", "PASSWORD", "DATETIME", "DUMMY", "OCI_IDENTITY_DOMAINS_ID", "OCI_CORE_IMAGE_ID", "OCI_CORE_INSTANCESHAPEWITHFLEX_NAME", "OCI_CORE_INSTANCESHAPE_NAME", "OCI_CORE_NATGATEWAY_ID", "OCI_CORE_INSTANCE_ID", "OCI_CORE_SUBNET_ID", "OCI_CORE_SERVICEGATEWAY_ID", "OCI_LOGAN_LOGGROUP_ID", "OCI_LOGAN_SCHEDULEDTASK_ID", "OCI_LOGAN_LOGENTITY_ID", "OCI_LOGAN_ENTITYTYPE_ID", "OCI_MGMT_AGENT_ID", "OCI_LOGAN_SOURCE_ID", "OCI_CORE_NSG_ID", "OCI_CORE_VCN_ID", "OCI_IDENTITY_AVAILABILITYDOMAIN_NAME", "OCI_IDENTITY_COMPARTMENT_ID", "OCI_IDENTITY_FAULTDOMAIN_NAME", "OCI_IDENTITY_REGION_NAME", "OCI_DATABASE_DBSYSTEM_ID", "OCI_DATABASE_DBHOME_ID", "OCI_DATABASE_DBHOME_DBVERSION", "OCI_DATABASE_DATABASE_ID", "OCI_DATABASE_AUTONOMOUSDATABASE_ID", "OCI_DATABASE_AUTONOMOUSDATABASEVERSION_ID", "OCI_DATABASE_AUTONOMOUSCONTAINERDATABASE_ID", "OCI_KMS_KEY_ID", "OCI_KMS_SECRET_ID", "OCI_CONTAINER_CLUSTER_ID", "OCI_KUBERNETES_VERSIONS_ID", "OCI_BLOCKSTORAGE_POLICIES_ID", "OCI_IDENTITY_GROUPS_ID", "OCI_IDENTITY_DYNAMICGROUPS_ID", "OCI_LOADBALANCER_LOADBALANCER_ID", "OCI_MOUNT_TARGET_ID", "OCI_IDENTITY_TAG_VALUE", "OCI_ODS_PROJECT_ID", "OCI_RESOURCEMANAGER_PRIVATEENDPOINT_ID", "OCI_APM_DOMAIN_ID", "OCI_CORE_SSH_PUBLICKEY", "OCI_KMS_VAULT_ID", "OCI_LOADBALANCER_NETWORKLOADBALANCER_ID", "OCI_LOADBALANCER_LOADBALANCER_RESERVEDIPS_ID", "OCI_DATABASE_MYSQL_SHAPE_ID", "OCI_DATABASE_MYSQL_CONFIGURATION_ID", "OCI_STORAGE_FILESTORAGE_EXPORTSET_ID", "OCI_STORAGE_FILESTORAGE_FILESYSTEM_ID", "OCI_STORAGE_OBJECTSTORAGE_BUCKET_NAME", "OCI_CORE_VCN_SECLIST_ID", "OCI_CORE_VOLUME_ID", "OCI_DATABASE_DATAGUARD_ID", "OCI_DATABASE_EXADATA_ID", "OCI_DATABASE_CLOUDVMCLUSTER_ID", "OCI_DATABASE_CDB_ID", "OCI_DATABASE_DATAGUARDASSOCIATION_ID", "OCI_DATABASE_DBNODE_ID", "OCI_CORE_VCN_NETWORKSECURITYGROUP_ID", "OCI_STORAGE_FILESTORAGE_MOUNTTARGET_ID", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param title:
            The value to assign to the title property of this BaseVariable.
        :type title: str

        :param description:
            The value to assign to the description property of this BaseVariable.
        :type description: str

        :param is_required:
            The value to assign to the is_required property of this BaseVariable.
        :type is_required: bool

        :param visible:
            The value to assign to the visible property of this BaseVariable.
        :type visible: str

        """
        self.swagger_types = {
            'type': 'str',
            'title': 'str',
            'description': 'str',
            'is_required': 'bool',
            'visible': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'title': 'title',
            'description': 'description',
            'is_required': 'isRequired',
            'visible': 'visible'
        }
        self._type = None
        self._title = None
        self._description = None
        self._is_required = None
        self._visible = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'OCI_LOADBALANCER_NETWORKLOADBALANCER_ID':
            return 'NetworkLoadBalancerId'

        if type == 'FILE':
            return 'FileVariable'

        if type == 'OCI_CORE_NATGATEWAY_ID':
            return 'NatGatewayVariable'

        if type == 'ENUM':
            return 'EnumVariable'

        if type == 'OCI_CORE_INSTANCESHAPE_NAME':
            return 'InstanceShapeVariable'

        if type == 'OCI_DATABASE_AUTONOMOUSCONTAINERDATABASE_ID':
            return 'AutonomousContainerDbVariable'

        if type == 'OCI_DATABASE_DATABASE_ID':
            return 'DataBaseVariable'

        if type == 'OCI_DATABASE_AUTONOMOUSDATABASEVERSION_ID':
            return 'AutonomousDatabaseVersionVariable'

        if type == 'OCI_IDENTITY_REGION_NAME':
            return 'RegionVariable'

        if type == 'OCI_CORE_VOLUME_ID':
            return 'VolumeId'

        if type == 'OCI_CORE_VCN_NETWORKSECURITYGROUP_ID':
            return 'VcnNetworkSecurityGroupId'

        if type == 'INTEGER':
            return 'IntegerVariable'

        if type == 'OCI_DATABASE_DBNODE_ID':
            return 'DatabaseDbNodeId'

        if type == 'TEXT':
            return 'MultilineVariable'

        if type == 'PASSWORD':
            return 'PasswordVariable'

        if type == 'ARRAY':
            return 'ArrayVariable'

        if type == 'OCI_MGMT_AGENT_ID':
            return 'ManagementAgents'

        if type == 'OCI_BLOCKSTORAGE_POLICIES_ID':
            return 'VolumeBackupPoliciesVariable'

        if type == 'OCI_LOGAN_SCHEDULEDTASK_ID':
            return 'LogAnalyticsScheduledTasks'

        if type == 'OCI_KMS_VAULT_ID':
            return 'KmsVaultVariable'

        if type == 'OCI_CORE_SERVICEGATEWAY_ID':
            return 'ServiceGatewayVariable'

        if type == 'OCI_LOGAN_LOGENTITY_ID':
            return 'LogAnalyticsLogEntities'

        if type == 'OCI_CORE_VCN_SECLIST_ID':
            return 'VcnSecListId'

        if type == 'OCI_CORE_NSG_ID':
            return 'NsgVariable'

        if type == 'OCI_IDENTITY_DYNAMICGROUPS_ID':
            return 'DynamicGroupsVariable'

        if type == 'OCI_ODS_PROJECT_ID':
            return 'OdsProjectVariable'

        if type == 'OCI_MOUNT_TARGET_ID':
            return 'MountTargetsVariable'

        if type == 'OCI_IDENTITY_DOMAINS_ID':
            return 'IdentityDomainVariable'

        if type == 'OCI_STORAGE_OBJECTSTORAGE_BUCKET_NAME':
            return 'ObjectStorageBucketName'

        if type == 'OCI_DATABASE_MYSQL_CONFIGURATION_ID':
            return 'MysqlConfigurationId'

        if type == 'OCI_STORAGE_FILESTORAGE_EXPORTSET_ID':
            return 'FileStorageExportSetId'

        if type == 'OCI_KMS_SECRET_ID':
            return 'KmsSecretVariable'

        if type == 'DATETIME':
            return 'DatetimeVariable'

        if type == 'OCI_DATABASE_DATAGUARDASSOCIATION_ID':
            return 'DatabaseDataguardAssociationId'

        if type == 'OCI_LOGAN_ENTITYTYPE_ID':
            return 'LogAnalyticsEntityTypes'

        if type == 'OCI_IDENTITY_GROUPS_ID':
            return 'GroupsVariable'

        if type == 'OCI_APM_DOMAIN_ID':
            return 'ApmDomainVariable'

        if type == 'OCI_DATABASE_AUTONOMOUSDATABASE_ID':
            return 'AutonomousDataBaseVariable'

        if type == 'OCI_IDENTITY_AVAILABILITYDOMAIN_NAME':
            return 'AvailabilityDomainVariable'

        if type == 'OCI_KUBERNETES_VERSIONS_ID':
            return 'KubernetesVersionsVariable'

        if type == 'OCI_LOADBALANCER_LOADBALANCER_ID':
            return 'LoadBalancerVariable'

        if type == 'OCI_CORE_IMAGE_ID':
            return 'ImageVariable'

        if type == 'OCI_LOADBALANCER_LOADBALANCER_RESERVEDIPS_ID':
            return 'LoadBalancerReservedIps'

        if type == 'OCI_KMS_KEY_ID':
            return 'KmsKeyVariable'

        if type == 'OCI_LOGAN_SOURCE_ID':
            return 'LogAnalyticsSources'

        if type == 'OCI_DATABASE_DATAGUARD_ID':
            return 'DatabaseDataGuardId'

        if type == 'OCI_IDENTITY_TAG_VALUE':
            return 'TagVariable'

        if type == 'OCI_DATABASE_CLOUDVMCLUSTER_ID':
            return 'CloudVmClusterId'

        if type == 'OCI_RESOURCEMANAGER_PRIVATEENDPOINT_ID':
            return 'PrivateEndpointVariable'

        if type == 'OCI_CONTAINER_CLUSTER_ID':
            return 'ContainerClusterVariable'

        if type == 'OCI_DATABASE_MYSQL_SHAPE_ID':
            return 'MysqlShapeId'

        if type == 'OCI_CORE_VCN_ID':
            return 'VcnVariable'

        if type == 'OCI_IDENTITY_COMPARTMENT_ID':
            return 'CompartmentVariable'

        if type == 'OCI_IDENTITY_FAULTDOMAIN_NAME':
            return 'FaultDomainVariable'

        if type == 'OCI_CORE_INSTANCESHAPEWITHFLEX_NAME':
            return 'InstanceShapeVariableWithFlex'

        if type == 'STRING':
            return 'StringVariable'

        if type == 'OCI_CORE_INSTANCE_ID':
            return 'InstanceVariable'

        if type == 'OCI_DATABASE_EXADATA_ID':
            return 'DatabaseExadataId'

        if type == 'OCI_DATABASE_DBHOME_ID':
            return 'DbHomeVariable'

        if type == 'OCI_STORAGE_FILESTORAGE_FILESYSTEM_ID':
            return 'FileStorageFilesystemId'

        if type == 'NUMBER':
            return 'NumberVariable'

        if type == 'OCI_CORE_SUBNET_ID':
            return 'SubnetVariable'

        if type == 'OCI_CORE_SSH_PUBLICKEY':
            return 'SshPublicKeyVariable'

        if type == 'OCI_LOGAN_LOGGROUP_ID':
            return 'LogAnalyticsLogGroup'

        if type == 'BOOLEAN':
            return 'BooleanVariable'

        if type == 'OCI_DATABASE_DBSYSTEM_ID':
            return 'DbSystemVariable'

        if type == 'OCI_STORAGE_FILESTORAGE_MOUNTTARGET_ID':
            return 'FileStorageMountTargetId'

        if type == 'OCI_DATABASE_CDB_ID':
            return 'DatabaseCdbId'

        if type == 'OCI_DATABASE_DBHOME_DBVERSION':
            return 'DbHomeVersionVariable'
        else:
            return 'BaseVariable'

    @property
    def type(self):
        """
        **[Required]** Gets the type of this BaseVariable.
        Type of the variable.

        Allowed values for this property are: "ARRAY", "BOOLEAN", "ENUM", "INTEGER", "NUMBER", "STRING", "TEXT", "FILE", "PASSWORD", "DATETIME", "DUMMY", "OCI_IDENTITY_DOMAINS_ID", "OCI_CORE_IMAGE_ID", "OCI_CORE_INSTANCESHAPEWITHFLEX_NAME", "OCI_CORE_INSTANCESHAPE_NAME", "OCI_CORE_NATGATEWAY_ID", "OCI_CORE_INSTANCE_ID", "OCI_CORE_SUBNET_ID", "OCI_CORE_SERVICEGATEWAY_ID", "OCI_LOGAN_LOGGROUP_ID", "OCI_LOGAN_SCHEDULEDTASK_ID", "OCI_LOGAN_LOGENTITY_ID", "OCI_LOGAN_ENTITYTYPE_ID", "OCI_MGMT_AGENT_ID", "OCI_LOGAN_SOURCE_ID", "OCI_CORE_NSG_ID", "OCI_CORE_VCN_ID", "OCI_IDENTITY_AVAILABILITYDOMAIN_NAME", "OCI_IDENTITY_COMPARTMENT_ID", "OCI_IDENTITY_FAULTDOMAIN_NAME", "OCI_IDENTITY_REGION_NAME", "OCI_DATABASE_DBSYSTEM_ID", "OCI_DATABASE_DBHOME_ID", "OCI_DATABASE_DBHOME_DBVERSION", "OCI_DATABASE_DATABASE_ID", "OCI_DATABASE_AUTONOMOUSDATABASE_ID", "OCI_DATABASE_AUTONOMOUSDATABASEVERSION_ID", "OCI_DATABASE_AUTONOMOUSCONTAINERDATABASE_ID", "OCI_KMS_KEY_ID", "OCI_KMS_SECRET_ID", "OCI_CONTAINER_CLUSTER_ID", "OCI_KUBERNETES_VERSIONS_ID", "OCI_BLOCKSTORAGE_POLICIES_ID", "OCI_IDENTITY_GROUPS_ID", "OCI_IDENTITY_DYNAMICGROUPS_ID", "OCI_LOADBALANCER_LOADBALANCER_ID", "OCI_MOUNT_TARGET_ID", "OCI_IDENTITY_TAG_VALUE", "OCI_ODS_PROJECT_ID", "OCI_RESOURCEMANAGER_PRIVATEENDPOINT_ID", "OCI_APM_DOMAIN_ID", "OCI_CORE_SSH_PUBLICKEY", "OCI_KMS_VAULT_ID", "OCI_LOADBALANCER_NETWORKLOADBALANCER_ID", "OCI_LOADBALANCER_LOADBALANCER_RESERVEDIPS_ID", "OCI_DATABASE_MYSQL_SHAPE_ID", "OCI_DATABASE_MYSQL_CONFIGURATION_ID", "OCI_STORAGE_FILESTORAGE_EXPORTSET_ID", "OCI_STORAGE_FILESTORAGE_FILESYSTEM_ID", "OCI_STORAGE_OBJECTSTORAGE_BUCKET_NAME", "OCI_CORE_VCN_SECLIST_ID", "OCI_CORE_VOLUME_ID", "OCI_DATABASE_DATAGUARD_ID", "OCI_DATABASE_EXADATA_ID", "OCI_DATABASE_CLOUDVMCLUSTER_ID", "OCI_DATABASE_CDB_ID", "OCI_DATABASE_DATAGUARDASSOCIATION_ID", "OCI_DATABASE_DBNODE_ID", "OCI_CORE_VCN_NETWORKSECURITYGROUP_ID", "OCI_STORAGE_FILESTORAGE_MOUNTTARGET_ID", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this BaseVariable.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this BaseVariable.
        Type of the variable.


        :param type: The type of this BaseVariable.
        :type: str
        """
        allowed_values = ["ARRAY", "BOOLEAN", "ENUM", "INTEGER", "NUMBER", "STRING", "TEXT", "FILE", "PASSWORD", "DATETIME", "DUMMY", "OCI_IDENTITY_DOMAINS_ID", "OCI_CORE_IMAGE_ID", "OCI_CORE_INSTANCESHAPEWITHFLEX_NAME", "OCI_CORE_INSTANCESHAPE_NAME", "OCI_CORE_NATGATEWAY_ID", "OCI_CORE_INSTANCE_ID", "OCI_CORE_SUBNET_ID", "OCI_CORE_SERVICEGATEWAY_ID", "OCI_LOGAN_LOGGROUP_ID", "OCI_LOGAN_SCHEDULEDTASK_ID", "OCI_LOGAN_LOGENTITY_ID", "OCI_LOGAN_ENTITYTYPE_ID", "OCI_MGMT_AGENT_ID", "OCI_LOGAN_SOURCE_ID", "OCI_CORE_NSG_ID", "OCI_CORE_VCN_ID", "OCI_IDENTITY_AVAILABILITYDOMAIN_NAME", "OCI_IDENTITY_COMPARTMENT_ID", "OCI_IDENTITY_FAULTDOMAIN_NAME", "OCI_IDENTITY_REGION_NAME", "OCI_DATABASE_DBSYSTEM_ID", "OCI_DATABASE_DBHOME_ID", "OCI_DATABASE_DBHOME_DBVERSION", "OCI_DATABASE_DATABASE_ID", "OCI_DATABASE_AUTONOMOUSDATABASE_ID", "OCI_DATABASE_AUTONOMOUSDATABASEVERSION_ID", "OCI_DATABASE_AUTONOMOUSCONTAINERDATABASE_ID", "OCI_KMS_KEY_ID", "OCI_KMS_SECRET_ID", "OCI_CONTAINER_CLUSTER_ID", "OCI_KUBERNETES_VERSIONS_ID", "OCI_BLOCKSTORAGE_POLICIES_ID", "OCI_IDENTITY_GROUPS_ID", "OCI_IDENTITY_DYNAMICGROUPS_ID", "OCI_LOADBALANCER_LOADBALANCER_ID", "OCI_MOUNT_TARGET_ID", "OCI_IDENTITY_TAG_VALUE", "OCI_ODS_PROJECT_ID", "OCI_RESOURCEMANAGER_PRIVATEENDPOINT_ID", "OCI_APM_DOMAIN_ID", "OCI_CORE_SSH_PUBLICKEY", "OCI_KMS_VAULT_ID", "OCI_LOADBALANCER_NETWORKLOADBALANCER_ID", "OCI_LOADBALANCER_LOADBALANCER_RESERVEDIPS_ID", "OCI_DATABASE_MYSQL_SHAPE_ID", "OCI_DATABASE_MYSQL_CONFIGURATION_ID", "OCI_STORAGE_FILESTORAGE_EXPORTSET_ID", "OCI_STORAGE_FILESTORAGE_FILESYSTEM_ID", "OCI_STORAGE_OBJECTSTORAGE_BUCKET_NAME", "OCI_CORE_VCN_SECLIST_ID", "OCI_CORE_VOLUME_ID", "OCI_DATABASE_DATAGUARD_ID", "OCI_DATABASE_EXADATA_ID", "OCI_DATABASE_CLOUDVMCLUSTER_ID", "OCI_DATABASE_CDB_ID", "OCI_DATABASE_DATAGUARDASSOCIATION_ID", "OCI_DATABASE_DBNODE_ID", "OCI_CORE_VCN_NETWORKSECURITYGROUP_ID", "OCI_STORAGE_FILESTORAGE_MOUNTTARGET_ID"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def title(self):
        """
        Gets the title of this BaseVariable.
        The display name for the variable as shown in the UI.


        :return: The title of this BaseVariable.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this BaseVariable.
        The display name for the variable as shown in the UI.


        :param title: The title of this BaseVariable.
        :type: str
        """
        self._title = title

    @property
    def description(self):
        """
        Gets the description of this BaseVariable.
        Detailed information about this variable's purpose and usage.


        :return: The description of this BaseVariable.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this BaseVariable.
        Detailed information about this variable's purpose and usage.


        :param description: The description of this BaseVariable.
        :type: str
        """
        self._description = description

    @property
    def is_required(self):
        """
        Gets the is_required of this BaseVariable.
        Indicates if this input variable is required for stack execution.


        :return: The is_required of this BaseVariable.
        :rtype: bool
        """
        return self._is_required

    @is_required.setter
    def is_required(self, is_required):
        """
        Sets the is_required of this BaseVariable.
        Indicates if this input variable is required for stack execution.


        :param is_required: The is_required of this BaseVariable.
        :type: bool
        """
        self._is_required = is_required

    @property
    def visible(self):
        """
        Gets the visible of this BaseVariable.
        Hint to control whether this variable is visible.


        :return: The visible of this BaseVariable.
        :rtype: str
        """
        return self._visible

    @visible.setter
    def visible(self, visible):
        """
        Sets the visible of this BaseVariable.
        Hint to control whether this variable is visible.


        :param visible: The visible of this BaseVariable.
        :type: str
        """
        self._visible = visible

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
