# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .catalog_result_payload import CatalogResultPayload
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CatalogTemplateResultConfig(CatalogResultPayload):
    """
    Catalog par result config.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CatalogTemplateResultConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.CatalogTemplateResultConfig.config_result_type` attribute
        of this class is ``TEMPLATE_RESULT_CONFIG`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_result_type:
            The value to assign to the config_result_type property of this CatalogTemplateResultConfig.
            Allowed values for this property are: "PAR_RESULT_CONFIG", "TEMPLATE_RESULT_CONFIG", "GIT_RESULT_CONFIG"
        :type config_result_type: str

        :param working_directory:
            The value to assign to the working_directory property of this CatalogTemplateResultConfig.
        :type working_directory: str

        :param template_id:
            The value to assign to the template_id property of this CatalogTemplateResultConfig.
        :type template_id: str

        """
        self.swagger_types = {
            'config_result_type': 'str',
            'working_directory': 'str',
            'template_id': 'str'
        }
        self.attribute_map = {
            'config_result_type': 'configResultType',
            'working_directory': 'workingDirectory',
            'template_id': 'templateId'
        }
        self._config_result_type = None
        self._working_directory = None
        self._template_id = None
        self._config_result_type = 'TEMPLATE_RESULT_CONFIG'

    @property
    def template_id(self):
        """
        Gets the template_id of this CatalogTemplateResultConfig.
        template id


        :return: The template_id of this CatalogTemplateResultConfig.
        :rtype: str
        """
        return self._template_id

    @template_id.setter
    def template_id(self, template_id):
        """
        Sets the template_id of this CatalogTemplateResultConfig.
        template id


        :param template_id: The template_id of this CatalogTemplateResultConfig.
        :type: str
        """
        self._template_id = template_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
