# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CompliancePolicyRuleSummary(object):
    """
    Summary information about a CompliancePolicyRule.
    """

    #: A constant which can be used with the severity property of a CompliancePolicyRuleSummary.
    #: This constant has a value of "CRITICAL"
    SEVERITY_CRITICAL = "CRITICAL"

    #: A constant which can be used with the severity property of a CompliancePolicyRuleSummary.
    #: This constant has a value of "HIGH"
    SEVERITY_HIGH = "HIGH"

    #: A constant which can be used with the severity property of a CompliancePolicyRuleSummary.
    #: This constant has a value of "MEDIUM"
    SEVERITY_MEDIUM = "MEDIUM"

    #: A constant which can be used with the severity property of a CompliancePolicyRuleSummary.
    #: This constant has a value of "LOW"
    SEVERITY_LOW = "LOW"

    def __init__(self, **kwargs):
        """
        Initializes a new CompliancePolicyRuleSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this CompliancePolicyRuleSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this CompliancePolicyRuleSummary.
        :type display_name: str

        :param compliance_policy_id:
            The value to assign to the compliance_policy_id property of this CompliancePolicyRuleSummary.
        :type compliance_policy_id: str

        :param product_version:
            The value to assign to the product_version property of this CompliancePolicyRuleSummary.
        :type product_version: oci.fleet_apps_management.models.ProductVersionDetails

        :param patch_type_id:
            The value to assign to the patch_type_id property of this CompliancePolicyRuleSummary.
        :type patch_type_id: list[str]

        :param severity:
            The value to assign to the severity property of this CompliancePolicyRuleSummary.
            Allowed values for items in this list are: "CRITICAL", "HIGH", "MEDIUM", "LOW", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type severity: list[str]

        :param patch_selection:
            The value to assign to the patch_selection property of this CompliancePolicyRuleSummary.
        :type patch_selection: oci.fleet_apps_management.models.PatchSelectionDetails

        :param grace_period:
            The value to assign to the grace_period property of this CompliancePolicyRuleSummary.
        :type grace_period: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CompliancePolicyRuleSummary.
        :type compartment_id: str

        :param time_created:
            The value to assign to the time_created property of this CompliancePolicyRuleSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this CompliancePolicyRuleSummary.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this CompliancePolicyRuleSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this CompliancePolicyRuleSummary.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CompliancePolicyRuleSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CompliancePolicyRuleSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this CompliancePolicyRuleSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compliance_policy_id': 'str',
            'product_version': 'ProductVersionDetails',
            'patch_type_id': 'list[str]',
            'severity': 'list[str]',
            'patch_selection': 'PatchSelectionDetails',
            'grace_period': 'str',
            'compartment_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compliance_policy_id': 'compliancePolicyId',
            'product_version': 'productVersion',
            'patch_type_id': 'patchTypeId',
            'severity': 'severity',
            'patch_selection': 'patchSelection',
            'grace_period': 'gracePeriod',
            'compartment_id': 'compartmentId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._compliance_policy_id = None
        self._product_version = None
        self._patch_type_id = None
        self._severity = None
        self._patch_selection = None
        self._grace_period = None
        self._compartment_id = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this CompliancePolicyRuleSummary.
        Unique OCID of the CompliancePolicyRule.


        :return: The id of this CompliancePolicyRuleSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CompliancePolicyRuleSummary.
        Unique OCID of the CompliancePolicyRule.


        :param id: The id of this CompliancePolicyRuleSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CompliancePolicyRuleSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this CompliancePolicyRuleSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CompliancePolicyRuleSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this CompliancePolicyRuleSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def compliance_policy_id(self):
        """
        **[Required]** Gets the compliance_policy_id of this CompliancePolicyRuleSummary.
        Unique OCID of the CompliancePolicy.


        :return: The compliance_policy_id of this CompliancePolicyRuleSummary.
        :rtype: str
        """
        return self._compliance_policy_id

    @compliance_policy_id.setter
    def compliance_policy_id(self, compliance_policy_id):
        """
        Sets the compliance_policy_id of this CompliancePolicyRuleSummary.
        Unique OCID of the CompliancePolicy.


        :param compliance_policy_id: The compliance_policy_id of this CompliancePolicyRuleSummary.
        :type: str
        """
        self._compliance_policy_id = compliance_policy_id

    @property
    def product_version(self):
        """
        **[Required]** Gets the product_version of this CompliancePolicyRuleSummary.

        :return: The product_version of this CompliancePolicyRuleSummary.
        :rtype: oci.fleet_apps_management.models.ProductVersionDetails
        """
        return self._product_version

    @product_version.setter
    def product_version(self, product_version):
        """
        Sets the product_version of this CompliancePolicyRuleSummary.

        :param product_version: The product_version of this CompliancePolicyRuleSummary.
        :type: oci.fleet_apps_management.models.ProductVersionDetails
        """
        self._product_version = product_version

    @property
    def patch_type_id(self):
        """
        **[Required]** Gets the patch_type_id of this CompliancePolicyRuleSummary.
        PlatformConfiguration OCID for the patch type to which this CompliancePolicyRule applies.


        :return: The patch_type_id of this CompliancePolicyRuleSummary.
        :rtype: list[str]
        """
        return self._patch_type_id

    @patch_type_id.setter
    def patch_type_id(self, patch_type_id):
        """
        Sets the patch_type_id of this CompliancePolicyRuleSummary.
        PlatformConfiguration OCID for the patch type to which this CompliancePolicyRule applies.


        :param patch_type_id: The patch_type_id of this CompliancePolicyRuleSummary.
        :type: list[str]
        """
        self._patch_type_id = patch_type_id

    @property
    def severity(self):
        """
        Gets the severity of this CompliancePolicyRuleSummary.
        Severity to which this CompliancePolicyRule applies.

        Allowed values for items in this list are: "CRITICAL", "HIGH", "MEDIUM", "LOW", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The severity of this CompliancePolicyRuleSummary.
        :rtype: list[str]
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this CompliancePolicyRuleSummary.
        Severity to which this CompliancePolicyRule applies.


        :param severity: The severity of this CompliancePolicyRuleSummary.
        :type: list[str]
        """
        allowed_values = ["CRITICAL", "HIGH", "MEDIUM", "LOW"]
        if severity:
            severity[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in severity]
        self._severity = severity

    @property
    def patch_selection(self):
        """
        **[Required]** Gets the patch_selection of this CompliancePolicyRuleSummary.

        :return: The patch_selection of this CompliancePolicyRuleSummary.
        :rtype: oci.fleet_apps_management.models.PatchSelectionDetails
        """
        return self._patch_selection

    @patch_selection.setter
    def patch_selection(self, patch_selection):
        """
        Sets the patch_selection of this CompliancePolicyRuleSummary.

        :param patch_selection: The patch_selection of this CompliancePolicyRuleSummary.
        :type: oci.fleet_apps_management.models.PatchSelectionDetails
        """
        self._patch_selection = patch_selection

    @property
    def grace_period(self):
        """
        Gets the grace_period of this CompliancePolicyRuleSummary.
        Grace period in days,weeks,months or years the exemption is applicable for the rule.
        This enables a grace period when Fleet Application Management doesn't report the product as noncompliant when patch is not applied.


        :return: The grace_period of this CompliancePolicyRuleSummary.
        :rtype: str
        """
        return self._grace_period

    @grace_period.setter
    def grace_period(self, grace_period):
        """
        Sets the grace_period of this CompliancePolicyRuleSummary.
        Grace period in days,weeks,months or years the exemption is applicable for the rule.
        This enables a grace period when Fleet Application Management doesn't report the product as noncompliant when patch is not applied.


        :param grace_period: The grace_period of this CompliancePolicyRuleSummary.
        :type: str
        """
        self._grace_period = grace_period

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CompliancePolicyRuleSummary.
        The OCID of the compartment the CompliancePolicyRule belongs to.


        :return: The compartment_id of this CompliancePolicyRuleSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CompliancePolicyRuleSummary.
        The OCID of the compartment the CompliancePolicyRule belongs to.


        :param compartment_id: The compartment_id of this CompliancePolicyRuleSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this CompliancePolicyRuleSummary.
        The date and time the CompliancePolicyRule was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this CompliancePolicyRuleSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this CompliancePolicyRuleSummary.
        The date and time the CompliancePolicyRule was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this CompliancePolicyRuleSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this CompliancePolicyRuleSummary.
        The date and time the CompliancePolicyRule was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this CompliancePolicyRuleSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this CompliancePolicyRuleSummary.
        The date and time the CompliancePolicyRule was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this CompliancePolicyRuleSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this CompliancePolicyRuleSummary.
        The current state of the CompliancePolicyRule.


        :return: The lifecycle_state of this CompliancePolicyRuleSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this CompliancePolicyRuleSummary.
        The current state of the CompliancePolicyRule.


        :param lifecycle_state: The lifecycle_state of this CompliancePolicyRuleSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this CompliancePolicyRuleSummary.
        A message that describes the current state of the CompliancePolicyRule in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :return: The lifecycle_details of this CompliancePolicyRuleSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this CompliancePolicyRuleSummary.
        A message that describes the current state of the CompliancePolicyRule in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :param lifecycle_details: The lifecycle_details of this CompliancePolicyRuleSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CompliancePolicyRuleSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CompliancePolicyRuleSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CompliancePolicyRuleSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CompliancePolicyRuleSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CompliancePolicyRuleSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CompliancePolicyRuleSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CompliancePolicyRuleSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CompliancePolicyRuleSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this CompliancePolicyRuleSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this CompliancePolicyRuleSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this CompliancePolicyRuleSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this CompliancePolicyRuleSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
