# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DiscoveredTarget(object):
    """
    A target that is discovered by the Software discovery process.
    """

    #: A constant which can be used with the operation property of a DiscoveredTarget.
    #: This constant has a value of "ADD"
    OPERATION_ADD = "ADD"

    #: A constant which can be used with the operation property of a DiscoveredTarget.
    #: This constant has a value of "REMOVE"
    OPERATION_REMOVE = "REMOVE"

    def __init__(self, **kwargs):
        """
        Initializes a new DiscoveredTarget object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param target_id:
            The value to assign to the target_id property of this DiscoveredTarget.
        :type target_id: str

        :param target_name:
            The value to assign to the target_name property of this DiscoveredTarget.
        :type target_name: str

        :param product:
            The value to assign to the product property of this DiscoveredTarget.
        :type product: str

        :param resource_id:
            The value to assign to the resource_id property of this DiscoveredTarget.
        :type resource_id: str

        :param version:
            The value to assign to the version property of this DiscoveredTarget.
        :type version: str

        :param operation:
            The value to assign to the operation property of this DiscoveredTarget.
            Allowed values for this property are: "ADD", "REMOVE"
        :type operation: str

        """
        self.swagger_types = {
            'target_id': 'str',
            'target_name': 'str',
            'product': 'str',
            'resource_id': 'str',
            'version': 'str',
            'operation': 'str'
        }
        self.attribute_map = {
            'target_id': 'targetId',
            'target_name': 'targetName',
            'product': 'product',
            'resource_id': 'resourceId',
            'version': 'version',
            'operation': 'operation'
        }
        self._target_id = None
        self._target_name = None
        self._product = None
        self._resource_id = None
        self._version = None
        self._operation = None

    @property
    def target_id(self):
        """
        **[Required]** Gets the target_id of this DiscoveredTarget.
        ID of the Target. Can be the target name if a separate ID is not available.


        :return: The target_id of this DiscoveredTarget.
        :rtype: str
        """
        return self._target_id

    @target_id.setter
    def target_id(self, target_id):
        """
        Sets the target_id of this DiscoveredTarget.
        ID of the Target. Can be the target name if a separate ID is not available.


        :param target_id: The target_id of this DiscoveredTarget.
        :type: str
        """
        self._target_id = target_id

    @property
    def target_name(self):
        """
        **[Required]** Gets the target_name of this DiscoveredTarget.
        Target Name.


        :return: The target_name of this DiscoveredTarget.
        :rtype: str
        """
        return self._target_name

    @target_name.setter
    def target_name(self, target_name):
        """
        Sets the target_name of this DiscoveredTarget.
        Target Name.


        :param target_name: The target_name of this DiscoveredTarget.
        :type: str
        """
        self._target_name = target_name

    @property
    def product(self):
        """
        **[Required]** Gets the product of this DiscoveredTarget.
        Product that the target belongs to.


        :return: The product of this DiscoveredTarget.
        :rtype: str
        """
        return self._product

    @product.setter
    def product(self, product):
        """
        Sets the product of this DiscoveredTarget.
        Product that the target belongs to.


        :param product: The product of this DiscoveredTarget.
        :type: str
        """
        self._product = product

    @property
    def resource_id(self):
        """
        **[Required]** Gets the resource_id of this DiscoveredTarget.
        Unique key that identifies the resource that the target belongs to.


        :return: The resource_id of this DiscoveredTarget.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this DiscoveredTarget.
        Unique key that identifies the resource that the target belongs to.


        :param resource_id: The resource_id of this DiscoveredTarget.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def version(self):
        """
        Gets the version of this DiscoveredTarget.
        Current version of the target.


        :return: The version of this DiscoveredTarget.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this DiscoveredTarget.
        Current version of the target.


        :param version: The version of this DiscoveredTarget.
        :type: str
        """
        self._version = version

    @property
    def operation(self):
        """
        Gets the operation of this DiscoveredTarget.
        Type of operation to be done against given target.
        ADD - Add target.
        REMOVE - Delete target.

        Allowed values for this property are: "ADD", "REMOVE"


        :return: The operation of this DiscoveredTarget.
        :rtype: str
        """
        return self._operation

    @operation.setter
    def operation(self, operation):
        """
        Sets the operation of this DiscoveredTarget.
        Type of operation to be done against given target.
        ADD - Add target.
        REMOVE - Delete target.


        :param operation: The operation of this DiscoveredTarget.
        :type: str
        """
        allowed_values = ["ADD", "REMOVE"]
        if not value_allowed_none_or_none_sentinel(operation, allowed_values):
            raise ValueError(
                f"Invalid value for `operation`, must be None or one of {allowed_values}"
            )
        self._operation = operation

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
