# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .resource_selection import ResourceSelection
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DynamicResourceSelection(ResourceSelection):
    """
    Dynamic Resource Selection Type
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DynamicResourceSelection object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.DynamicResourceSelection.resource_selection_type` attribute
        of this class is ``DYNAMIC`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param resource_selection_type:
            The value to assign to the resource_selection_type property of this DynamicResourceSelection.
            Allowed values for this property are: "DYNAMIC", "MANUAL"
        :type resource_selection_type: str

        :param rule_selection_criteria:
            The value to assign to the rule_selection_criteria property of this DynamicResourceSelection.
        :type rule_selection_criteria: oci.fleet_apps_management.models.SelectionCriteria

        """
        self.swagger_types = {
            'resource_selection_type': 'str',
            'rule_selection_criteria': 'SelectionCriteria'
        }
        self.attribute_map = {
            'resource_selection_type': 'resourceSelectionType',
            'rule_selection_criteria': 'ruleSelectionCriteria'
        }
        self._resource_selection_type = None
        self._rule_selection_criteria = None
        self._resource_selection_type = 'DYNAMIC'

    @property
    def rule_selection_criteria(self):
        """
        **[Required]** Gets the rule_selection_criteria of this DynamicResourceSelection.

        :return: The rule_selection_criteria of this DynamicResourceSelection.
        :rtype: oci.fleet_apps_management.models.SelectionCriteria
        """
        return self._rule_selection_criteria

    @rule_selection_criteria.setter
    def rule_selection_criteria(self, rule_selection_criteria):
        """
        Sets the rule_selection_criteria of this DynamicResourceSelection.

        :param rule_selection_criteria: The rule_selection_criteria of this DynamicResourceSelection.
        :type: oci.fleet_apps_management.models.SelectionCriteria
        """
        self._rule_selection_criteria = rule_selection_criteria

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
