# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ImportRunbookPrecheckRequiredValue(object):
    """
    Runbook import precheck required value.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ImportRunbookPrecheckRequiredValue object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param step_name:
            The value to assign to the step_name property of this ImportRunbookPrecheckRequiredValue.
        :type step_name: str

        :param value:
            The value to assign to the value property of this ImportRunbookPrecheckRequiredValue.
        :type value: str

        :param placeholder:
            The value to assign to the placeholder property of this ImportRunbookPrecheckRequiredValue.
        :type placeholder: str

        :param field:
            The value to assign to the field property of this ImportRunbookPrecheckRequiredValue.
        :type field: str

        """
        self.swagger_types = {
            'step_name': 'str',
            'value': 'str',
            'placeholder': 'str',
            'field': 'str'
        }
        self.attribute_map = {
            'step_name': 'stepName',
            'value': 'value',
            'placeholder': 'placeholder',
            'field': 'field'
        }
        self._step_name = None
        self._value = None
        self._placeholder = None
        self._field = None

    @property
    def step_name(self):
        """
        Gets the step_name of this ImportRunbookPrecheckRequiredValue.
        Step name for required value.


        :return: The step_name of this ImportRunbookPrecheckRequiredValue.
        :rtype: str
        """
        return self._step_name

    @step_name.setter
    def step_name(self, step_name):
        """
        Sets the step_name of this ImportRunbookPrecheckRequiredValue.
        Step name for required value.


        :param step_name: The step_name of this ImportRunbookPrecheckRequiredValue.
        :type: str
        """
        self._step_name = step_name

    @property
    def value(self):
        """
        Gets the value of this ImportRunbookPrecheckRequiredValue.
        Value for required value.


        :return: The value of this ImportRunbookPrecheckRequiredValue.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this ImportRunbookPrecheckRequiredValue.
        Value for required value.


        :param value: The value of this ImportRunbookPrecheckRequiredValue.
        :type: str
        """
        self._value = value

    @property
    def placeholder(self):
        """
        Gets the placeholder of this ImportRunbookPrecheckRequiredValue.
        placeholder.


        :return: The placeholder of this ImportRunbookPrecheckRequiredValue.
        :rtype: str
        """
        return self._placeholder

    @placeholder.setter
    def placeholder(self, placeholder):
        """
        Sets the placeholder of this ImportRunbookPrecheckRequiredValue.
        placeholder.


        :param placeholder: The placeholder of this ImportRunbookPrecheckRequiredValue.
        :type: str
        """
        self._placeholder = placeholder

    @property
    def field(self):
        """
        **[Required]** Gets the field of this ImportRunbookPrecheckRequiredValue.
        Field for required value.


        :return: The field of this ImportRunbookPrecheckRequiredValue.
        :rtype: str
        """
        return self._field

    @field.setter
    def field(self, field):
        """
        Sets the field of this ImportRunbookPrecheckRequiredValue.
        Field for required value.


        :param field: The field of this ImportRunbookPrecheckRequiredValue.
        :type: str
        """
        self._field = field

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
