# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class WorkflowGroup(object):
    """
    Workflow Group Layout.
    """

    #: A constant which can be used with the type property of a WorkflowGroup.
    #: This constant has a value of "PARALLEL_RESOURCE_GROUP"
    TYPE_PARALLEL_RESOURCE_GROUP = "PARALLEL_RESOURCE_GROUP"

    #: A constant which can be used with the type property of a WorkflowGroup.
    #: This constant has a value of "ROLLING_RESOURCE_GROUP"
    TYPE_ROLLING_RESOURCE_GROUP = "ROLLING_RESOURCE_GROUP"

    def __init__(self, **kwargs):
        """
        Initializes a new WorkflowGroup object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param group_name:
            The value to assign to the group_name property of this WorkflowGroup.
        :type group_name: str

        :param type:
            The value to assign to the type property of this WorkflowGroup.
            Allowed values for this property are: "PARALLEL_RESOURCE_GROUP", "ROLLING_RESOURCE_GROUP", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param steps:
            The value to assign to the steps property of this WorkflowGroup.
        :type steps: list[oci.fleet_apps_management.models.WorkflowComponent]

        """
        self.swagger_types = {
            'group_name': 'str',
            'type': 'str',
            'steps': 'list[WorkflowComponent]'
        }
        self.attribute_map = {
            'group_name': 'groupName',
            'type': 'type',
            'steps': 'steps'
        }
        self._group_name = None
        self._type = None
        self._steps = None

    @property
    def group_name(self):
        """
        **[Required]** Gets the group_name of this WorkflowGroup.
        Name of the group.


        :return: The group_name of this WorkflowGroup.
        :rtype: str
        """
        return self._group_name

    @group_name.setter
    def group_name(self, group_name):
        """
        Sets the group_name of this WorkflowGroup.
        Name of the group.


        :param group_name: The group_name of this WorkflowGroup.
        :type: str
        """
        self._group_name = group_name

    @property
    def type(self):
        """
        **[Required]** Gets the type of this WorkflowGroup.
        Workflow Group  Details.

        Allowed values for this property are: "PARALLEL_RESOURCE_GROUP", "ROLLING_RESOURCE_GROUP", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this WorkflowGroup.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this WorkflowGroup.
        Workflow Group  Details.


        :param type: The type of this WorkflowGroup.
        :type: str
        """
        allowed_values = ["PARALLEL_RESOURCE_GROUP", "ROLLING_RESOURCE_GROUP"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def steps(self):
        """
        **[Required]** Gets the steps of this WorkflowGroup.
        Steps within the Group.


        :return: The steps of this WorkflowGroup.
        :rtype: list[oci.fleet_apps_management.models.WorkflowComponent]
        """
        return self._steps

    @steps.setter
    def steps(self, steps):
        """
        Sets the steps of this WorkflowGroup.
        Steps within the Group.


        :param steps: The steps of this WorkflowGroup.
        :type: list[oci.fleet_apps_management.models.WorkflowComponent]
        """
        self._steps = steps

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
