# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .create_fsu_collection_details import CreateFsuCollectionDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateExadbStackFsuCollectionDetails(CreateFsuCollectionDetails):
    """
    Details to create an 'EXADB_STACK' type Exadata Fleet Update Collection.
    Currently, components allowed in an Exadata software stack are 'GUEST_OS' and 'GI'.
    At least two distinct component types are required for an Exadata software stack.
    Targets belonging to another 'EXADB_STACK' type Exadata Fleet Update Collection will be rejected.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateExadbStackFsuCollectionDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.CreateExadbStackFsuCollectionDetails.type` attribute
        of this class is ``EXADB_STACK`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateExadbStackFsuCollectionDetails.
        :type display_name: str

        :param type:
            The value to assign to the type property of this CreateExadbStackFsuCollectionDetails.
            Allowed values for this property are: "DB", "GI", "GUEST_OS", "EXADB_STACK"
        :type type: str

        :param service_type:
            The value to assign to the service_type property of this CreateExadbStackFsuCollectionDetails.
            Allowed values for this property are: "EXACS", "EXACC", "EXADBXS"
        :type service_type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateExadbStackFsuCollectionDetails.
        :type compartment_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateExadbStackFsuCollectionDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateExadbStackFsuCollectionDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param components:
            The value to assign to the components property of this CreateExadbStackFsuCollectionDetails.
        :type components: list[oci.fleet_software_update.models.CreateSoftwareComponentDetails]

        """
        self.swagger_types = {
            'display_name': 'str',
            'type': 'str',
            'service_type': 'str',
            'compartment_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'components': 'list[CreateSoftwareComponentDetails]'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'type': 'type',
            'service_type': 'serviceType',
            'compartment_id': 'compartmentId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'components': 'components'
        }
        self._display_name = None
        self._type = None
        self._service_type = None
        self._compartment_id = None
        self._freeform_tags = None
        self._defined_tags = None
        self._components = None
        self._type = 'EXADB_STACK'

    @property
    def components(self):
        """
        **[Required]** Gets the components of this CreateExadbStackFsuCollectionDetails.
        Details of components in an Exadata software stack.


        :return: The components of this CreateExadbStackFsuCollectionDetails.
        :rtype: list[oci.fleet_software_update.models.CreateSoftwareComponentDetails]
        """
        return self._components

    @components.setter
    def components(self, components):
        """
        Sets the components of this CreateExadbStackFsuCollectionDetails.
        Details of components in an Exadata software stack.


        :param components: The components of this CreateExadbStackFsuCollectionDetails.
        :type: list[oci.fleet_software_update.models.CreateSoftwareComponentDetails]
        """
        self._components = components

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
