# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateFsuDiscoveryDetails(object):
    """
    The information about new Exadata Fleet Update Discovery resource.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateFsuDiscoveryDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateFsuDiscoveryDetails.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateFsuDiscoveryDetails.
        :type compartment_id: str

        :param details:
            The value to assign to the details property of this CreateFsuDiscoveryDetails.
        :type details: oci.fleet_software_update.models.DiscoveryDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateFsuDiscoveryDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateFsuDiscoveryDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'compartment_id': 'str',
            'details': 'DiscoveryDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'details': 'details',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._compartment_id = None
        self._details = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateFsuDiscoveryDetails.
        Exadata Fleet Update Collection display name.


        :return: The display_name of this CreateFsuDiscoveryDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateFsuDiscoveryDetails.
        Exadata Fleet Update Collection display name.


        :param display_name: The display_name of this CreateFsuDiscoveryDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateFsuDiscoveryDetails.
        Compartment Identifier.


        :return: The compartment_id of this CreateFsuDiscoveryDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateFsuDiscoveryDetails.
        Compartment Identifier.


        :param compartment_id: The compartment_id of this CreateFsuDiscoveryDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def details(self):
        """
        **[Required]** Gets the details of this CreateFsuDiscoveryDetails.

        :return: The details of this CreateFsuDiscoveryDetails.
        :rtype: oci.fleet_software_update.models.DiscoveryDetails
        """
        return self._details

    @details.setter
    def details(self, details):
        """
        Sets the details of this CreateFsuDiscoveryDetails.

        :param details: The details of this CreateFsuDiscoveryDetails.
        :type: oci.fleet_software_update.models.DiscoveryDetails
        """
        self._details = details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateFsuDiscoveryDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateFsuDiscoveryDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateFsuDiscoveryDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateFsuDiscoveryDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateFsuDiscoveryDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateFsuDiscoveryDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateFsuDiscoveryDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateFsuDiscoveryDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
