# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .fsu_collection_summary import FsuCollectionSummary
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExadbStackFsuCollectionSummary(FsuCollectionSummary):
    """
    Summary of 'EXADB_STACK' type Exadata Fleet Update Collection.
    Currently, components allowed in an Exadata software stack are 'GUEST_OS' and 'GI'.
    At least two distinct component types are required for an Exadata software stack.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExadbStackFsuCollectionSummary object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.ExadbStackFsuCollectionSummary.type` attribute
        of this class is ``EXADB_STACK`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ExadbStackFsuCollectionSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this ExadbStackFsuCollectionSummary.
        :type display_name: str

        :param type:
            The value to assign to the type property of this ExadbStackFsuCollectionSummary.
            Allowed values for this property are: "DB", "GI", "GUEST_OS", "EXADB_STACK"
        :type type: str

        :param service_type:
            The value to assign to the service_type property of this ExadbStackFsuCollectionSummary.
            Allowed values for this property are: "EXACS", "EXACC", "EXADBXS"
        :type service_type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ExadbStackFsuCollectionSummary.
        :type compartment_id: str

        :param active_fsu_cycle:
            The value to assign to the active_fsu_cycle property of this ExadbStackFsuCollectionSummary.
        :type active_fsu_cycle: oci.fleet_software_update.models.ActiveCycleDetails

        :param target_count:
            The value to assign to the target_count property of this ExadbStackFsuCollectionSummary.
        :type target_count: int

        :param time_created:
            The value to assign to the time_created property of this ExadbStackFsuCollectionSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ExadbStackFsuCollectionSummary.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ExadbStackFsuCollectionSummary.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "NEEDS_ATTENTION", "DELETING", "DELETED", "FAILED"
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this ExadbStackFsuCollectionSummary.
        :type lifecycle_details: str

        :param last_completed_fsu_cycle_id:
            The value to assign to the last_completed_fsu_cycle_id property of this ExadbStackFsuCollectionSummary.
        :type last_completed_fsu_cycle_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ExadbStackFsuCollectionSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ExadbStackFsuCollectionSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ExadbStackFsuCollectionSummary.
        :type system_tags: dict(str, dict(str, object))

        :param components:
            The value to assign to the components property of this ExadbStackFsuCollectionSummary.
        :type components: list[oci.fleet_software_update.models.SoftwareComponentSummary]

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'type': 'str',
            'service_type': 'str',
            'compartment_id': 'str',
            'active_fsu_cycle': 'ActiveCycleDetails',
            'target_count': 'int',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'last_completed_fsu_cycle_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'components': 'list[SoftwareComponentSummary]'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'type': 'type',
            'service_type': 'serviceType',
            'compartment_id': 'compartmentId',
            'active_fsu_cycle': 'activeFsuCycle',
            'target_count': 'targetCount',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'last_completed_fsu_cycle_id': 'lastCompletedFsuCycleId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'components': 'components'
        }
        self._id = None
        self._display_name = None
        self._type = None
        self._service_type = None
        self._compartment_id = None
        self._active_fsu_cycle = None
        self._target_count = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._last_completed_fsu_cycle_id = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._components = None
        self._type = 'EXADB_STACK'

    @property
    def components(self):
        """
        **[Required]** Gets the components of this ExadbStackFsuCollectionSummary.
        Summary of components in an Exadata software stack.


        :return: The components of this ExadbStackFsuCollectionSummary.
        :rtype: list[oci.fleet_software_update.models.SoftwareComponentSummary]
        """
        return self._components

    @components.setter
    def components(self, components):
        """
        Sets the components of this ExadbStackFsuCollectionSummary.
        Summary of components in an Exadata software stack.


        :param components: The components of this ExadbStackFsuCollectionSummary.
        :type: list[oci.fleet_software_update.models.SoftwareComponentSummary]
        """
        self._components = components

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
