# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .target_details import TargetDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExadbVmClusterTargetSummary(TargetDetails):
    """
    Details of a ExadbVmCluster on Exascale Infrastructure a target member of a Exadata Fleet Update Collection.
    Stored references of the resource documented in
    https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/ExadbVmCluster/
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExadbVmClusterTargetSummary object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.ExadbVmClusterTargetSummary.entity_type` attribute
        of this class is ``EXADBVMCLUSTER`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param entity_type:
            The value to assign to the entity_type property of this ExadbVmClusterTargetSummary.
            Allowed values for this property are: "DATABASE", "VMCLUSTER", "CLOUDVMCLUSTER", "EXADBVMCLUSTER"
        :type entity_type: str

        :param id:
            The value to assign to the id property of this ExadbVmClusterTargetSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ExadbVmClusterTargetSummary.
        :type compartment_id: str

        :param exascale_db_storage_vault_id:
            The value to assign to the exascale_db_storage_vault_id property of this ExadbVmClusterTargetSummary.
        :type exascale_db_storage_vault_id: str

        :param software_image_id:
            The value to assign to the software_image_id property of this ExadbVmClusterTargetSummary.
        :type software_image_id: str

        :param system_version:
            The value to assign to the system_version property of this ExadbVmClusterTargetSummary.
        :type system_version: str

        """
        self.swagger_types = {
            'entity_type': 'str',
            'id': 'str',
            'compartment_id': 'str',
            'exascale_db_storage_vault_id': 'str',
            'software_image_id': 'str',
            'system_version': 'str'
        }
        self.attribute_map = {
            'entity_type': 'entityType',
            'id': 'id',
            'compartment_id': 'compartmentId',
            'exascale_db_storage_vault_id': 'exascaleDbStorageVaultId',
            'software_image_id': 'softwareImageId',
            'system_version': 'systemVersion'
        }
        self._entity_type = None
        self._id = None
        self._compartment_id = None
        self._exascale_db_storage_vault_id = None
        self._software_image_id = None
        self._system_version = None
        self._entity_type = 'EXADBVMCLUSTER'

    @property
    def exascale_db_storage_vault_id(self):
        """
        Gets the exascale_db_storage_vault_id of this ExadbVmClusterTargetSummary.
        OCID of the related Exadata Database Storage Vault.


        :return: The exascale_db_storage_vault_id of this ExadbVmClusterTargetSummary.
        :rtype: str
        """
        return self._exascale_db_storage_vault_id

    @exascale_db_storage_vault_id.setter
    def exascale_db_storage_vault_id(self, exascale_db_storage_vault_id):
        """
        Sets the exascale_db_storage_vault_id of this ExadbVmClusterTargetSummary.
        OCID of the related Exadata Database Storage Vault.


        :param exascale_db_storage_vault_id: The exascale_db_storage_vault_id of this ExadbVmClusterTargetSummary.
        :type: str
        """
        self._exascale_db_storage_vault_id = exascale_db_storage_vault_id

    @property
    def software_image_id(self):
        """
        Gets the software_image_id of this ExadbVmClusterTargetSummary.
        OCID of the Grid Infrastructure software image.


        :return: The software_image_id of this ExadbVmClusterTargetSummary.
        :rtype: str
        """
        return self._software_image_id

    @software_image_id.setter
    def software_image_id(self, software_image_id):
        """
        Sets the software_image_id of this ExadbVmClusterTargetSummary.
        OCID of the Grid Infrastructure software image.


        :param software_image_id: The software_image_id of this ExadbVmClusterTargetSummary.
        :type: str
        """
        self._software_image_id = software_image_id

    @property
    def system_version(self):
        """
        Gets the system_version of this ExadbVmClusterTargetSummary.
        Exadata Image (Guest OS) version.


        :return: The system_version of this ExadbVmClusterTargetSummary.
        :rtype: str
        """
        return self._system_version

    @system_version.setter
    def system_version(self, system_version):
        """
        Sets the system_version of this ExadbVmClusterTargetSummary.
        Exadata Image (Guest OS) version.


        :param system_version: The system_version of this ExadbVmClusterTargetSummary.
        :type: str
        """
        self._system_version = system_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
