# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TargetEntry(object):
    """
    Details to specify a target to add or remove from an Exadata Fleet Update Collection.
    """

    #: A constant which can be used with the entity_type property of a TargetEntry.
    #: This constant has a value of "DATABASE"
    ENTITY_TYPE_DATABASE = "DATABASE"

    #: A constant which can be used with the entity_type property of a TargetEntry.
    #: This constant has a value of "VMCLUSTER"
    ENTITY_TYPE_VMCLUSTER = "VMCLUSTER"

    #: A constant which can be used with the entity_type property of a TargetEntry.
    #: This constant has a value of "CLOUDVMCLUSTER"
    ENTITY_TYPE_CLOUDVMCLUSTER = "CLOUDVMCLUSTER"

    #: A constant which can be used with the entity_type property of a TargetEntry.
    #: This constant has a value of "EXADBVMCLUSTER"
    ENTITY_TYPE_EXADBVMCLUSTER = "EXADBVMCLUSTER"

    def __init__(self, **kwargs):
        """
        Initializes a new TargetEntry object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param entity_type:
            The value to assign to the entity_type property of this TargetEntry.
            Allowed values for this property are: "DATABASE", "VMCLUSTER", "CLOUDVMCLUSTER", "EXADBVMCLUSTER"
        :type entity_type: str

        :param identifier:
            The value to assign to the identifier property of this TargetEntry.
        :type identifier: str

        """
        self.swagger_types = {
            'entity_type': 'str',
            'identifier': 'str'
        }
        self.attribute_map = {
            'entity_type': 'entityType',
            'identifier': 'identifier'
        }
        self._entity_type = None
        self._identifier = None

    @property
    def entity_type(self):
        """
        **[Required]** Gets the entity_type of this TargetEntry.
        Resource entity type

        Allowed values for this property are: "DATABASE", "VMCLUSTER", "CLOUDVMCLUSTER", "EXADBVMCLUSTER"


        :return: The entity_type of this TargetEntry.
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type):
        """
        Sets the entity_type of this TargetEntry.
        Resource entity type


        :param entity_type: The entity_type of this TargetEntry.
        :type: str
        """
        allowed_values = ["DATABASE", "VMCLUSTER", "CLOUDVMCLUSTER", "EXADBVMCLUSTER"]
        if not value_allowed_none_or_none_sentinel(entity_type, allowed_values):
            raise ValueError(
                f"Invalid value for `entity_type`, must be None or one of {allowed_values}"
            )
        self._entity_type = entity_type

    @property
    def identifier(self):
        """
        **[Required]** Gets the identifier of this TargetEntry.
        Resource identifier OCID


        :return: The identifier of this TargetEntry.
        :rtype: str
        """
        return self._identifier

    @identifier.setter
    def identifier(self, identifier):
        """
        Sets the identifier of this TargetEntry.
        Resource identifier OCID


        :param identifier: The identifier of this TargetEntry.
        :type: str
        """
        self._identifier = identifier

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
