# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .api_schema_input_location import ApiSchemaInputLocation
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ApiSchemaObjectStorageInputLocation(ApiSchemaInputLocation):
    """
    The details of OCI Object Storage object location for Api schema.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ApiSchemaObjectStorageInputLocation object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent.models.ApiSchemaObjectStorageInputLocation.api_schema_input_location_type` attribute
        of this class is ``OBJECT_STORAGE_LOCATION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param api_schema_input_location_type:
            The value to assign to the api_schema_input_location_type property of this ApiSchemaObjectStorageInputLocation.
            Allowed values for this property are: "INLINE", "OBJECT_STORAGE_LOCATION"
        :type api_schema_input_location_type: str

        :param namespace_name:
            The value to assign to the namespace_name property of this ApiSchemaObjectStorageInputLocation.
        :type namespace_name: str

        :param bucket_name:
            The value to assign to the bucket_name property of this ApiSchemaObjectStorageInputLocation.
        :type bucket_name: str

        :param object_name:
            The value to assign to the object_name property of this ApiSchemaObjectStorageInputLocation.
        :type object_name: str

        """
        self.swagger_types = {
            'api_schema_input_location_type': 'str',
            'namespace_name': 'str',
            'bucket_name': 'str',
            'object_name': 'str'
        }
        self.attribute_map = {
            'api_schema_input_location_type': 'apiSchemaInputLocationType',
            'namespace_name': 'namespaceName',
            'bucket_name': 'bucketName',
            'object_name': 'objectName'
        }
        self._api_schema_input_location_type = None
        self._namespace_name = None
        self._bucket_name = None
        self._object_name = None
        self._api_schema_input_location_type = 'OBJECT_STORAGE_LOCATION'

    @property
    def namespace_name(self):
        """
        **[Required]** Gets the namespace_name of this ApiSchemaObjectStorageInputLocation.
        The namespace name of an object.


        :return: The namespace_name of this ApiSchemaObjectStorageInputLocation.
        :rtype: str
        """
        return self._namespace_name

    @namespace_name.setter
    def namespace_name(self, namespace_name):
        """
        Sets the namespace_name of this ApiSchemaObjectStorageInputLocation.
        The namespace name of an object.


        :param namespace_name: The namespace_name of this ApiSchemaObjectStorageInputLocation.
        :type: str
        """
        self._namespace_name = namespace_name

    @property
    def bucket_name(self):
        """
        **[Required]** Gets the bucket_name of this ApiSchemaObjectStorageInputLocation.
        The bucket name of an object.


        :return: The bucket_name of this ApiSchemaObjectStorageInputLocation.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this ApiSchemaObjectStorageInputLocation.
        The bucket name of an object.


        :param bucket_name: The bucket_name of this ApiSchemaObjectStorageInputLocation.
        :type: str
        """
        self._bucket_name = bucket_name

    @property
    def object_name(self):
        """
        **[Required]** Gets the object_name of this ApiSchemaObjectStorageInputLocation.
        The location/name of object.


        :return: The object_name of this ApiSchemaObjectStorageInputLocation.
        :rtype: str
        """
        return self._object_name

    @object_name.setter
    def object_name(self, object_name):
        """
        Sets the object_name of this ApiSchemaObjectStorageInputLocation.
        The location/name of object.


        :param object_name: The object_name of this ApiSchemaObjectStorageInputLocation.
        :type: str
        """
        self._object_name = object_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
