# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ToolConfig(object):
    """
    The configuration and type of Tool.
    """

    #: A constant which can be used with the tool_config_type property of a ToolConfig.
    #: This constant has a value of "SQL_TOOL_CONFIG"
    TOOL_CONFIG_TYPE_SQL_TOOL_CONFIG = "SQL_TOOL_CONFIG"

    #: A constant which can be used with the tool_config_type property of a ToolConfig.
    #: This constant has a value of "RAG_TOOL_CONFIG"
    TOOL_CONFIG_TYPE_RAG_TOOL_CONFIG = "RAG_TOOL_CONFIG"

    #: A constant which can be used with the tool_config_type property of a ToolConfig.
    #: This constant has a value of "FUNCTION_CALLING_TOOL_CONFIG"
    TOOL_CONFIG_TYPE_FUNCTION_CALLING_TOOL_CONFIG = "FUNCTION_CALLING_TOOL_CONFIG"

    #: A constant which can be used with the tool_config_type property of a ToolConfig.
    #: This constant has a value of "HTTP_ENDPOINT_TOOL_CONFIG"
    TOOL_CONFIG_TYPE_HTTP_ENDPOINT_TOOL_CONFIG = "HTTP_ENDPOINT_TOOL_CONFIG"

    #: A constant which can be used with the tool_config_type property of a ToolConfig.
    #: This constant has a value of "AGENT_TOOL_CONFIG"
    TOOL_CONFIG_TYPE_AGENT_TOOL_CONFIG = "AGENT_TOOL_CONFIG"

    def __init__(self, **kwargs):
        """
        Initializes a new ToolConfig object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.generative_ai_agent.models.SqlToolConfig`
        * :class:`~oci.generative_ai_agent.models.FunctionCallingToolConfig`
        * :class:`~oci.generative_ai_agent.models.HttpEndpointToolConfig`
        * :class:`~oci.generative_ai_agent.models.AgentToolConfig`
        * :class:`~oci.generative_ai_agent.models.RagToolConfig`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tool_config_type:
            The value to assign to the tool_config_type property of this ToolConfig.
            Allowed values for this property are: "SQL_TOOL_CONFIG", "RAG_TOOL_CONFIG", "FUNCTION_CALLING_TOOL_CONFIG", "HTTP_ENDPOINT_TOOL_CONFIG", "AGENT_TOOL_CONFIG", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type tool_config_type: str

        """
        self.swagger_types = {
            'tool_config_type': 'str'
        }
        self.attribute_map = {
            'tool_config_type': 'toolConfigType'
        }
        self._tool_config_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['toolConfigType']

        if type == 'SQL_TOOL_CONFIG':
            return 'SqlToolConfig'

        if type == 'FUNCTION_CALLING_TOOL_CONFIG':
            return 'FunctionCallingToolConfig'

        if type == 'HTTP_ENDPOINT_TOOL_CONFIG':
            return 'HttpEndpointToolConfig'

        if type == 'AGENT_TOOL_CONFIG':
            return 'AgentToolConfig'

        if type == 'RAG_TOOL_CONFIG':
            return 'RagToolConfig'
        else:
            return 'ToolConfig'

    @property
    def tool_config_type(self):
        """
        **[Required]** Gets the tool_config_type of this ToolConfig.
        The type of the Tool config.

        Allowed values for this property are: "SQL_TOOL_CONFIG", "RAG_TOOL_CONFIG", "FUNCTION_CALLING_TOOL_CONFIG", "HTTP_ENDPOINT_TOOL_CONFIG", "AGENT_TOOL_CONFIG", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The tool_config_type of this ToolConfig.
        :rtype: str
        """
        return self._tool_config_type

    @tool_config_type.setter
    def tool_config_type(self, tool_config_type):
        """
        Sets the tool_config_type of this ToolConfig.
        The type of the Tool config.


        :param tool_config_type: The tool_config_type of this ToolConfig.
        :type: str
        """
        allowed_values = ["SQL_TOOL_CONFIG", "RAG_TOOL_CONFIG", "FUNCTION_CALLING_TOOL_CONFIG", "HTTP_ENDPOINT_TOOL_CONFIG", "AGENT_TOOL_CONFIG"]
        if not value_allowed_none_or_none_sentinel(tool_config_type, allowed_values):
            tool_config_type = 'UNKNOWN_ENUM_VALUE'
        self._tool_config_type = tool_config_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
