# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateProvisionedCapacityDetails(object):
    """
    The data to update a provisioned capacity.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateProvisionedCapacityDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateProvisionedCapacityDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdateProvisionedCapacityDetails.
        :type description: str

        :param number_of_units:
            The value to assign to the number_of_units property of this UpdateProvisionedCapacityDetails.
        :type number_of_units: int

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateProvisionedCapacityDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateProvisionedCapacityDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'number_of_units': 'int',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'number_of_units': 'numberOfUnits',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._description = None
        self._number_of_units = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateProvisionedCapacityDetails.
        The name of the provisioned capacity.


        :return: The display_name of this UpdateProvisionedCapacityDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateProvisionedCapacityDetails.
        The name of the provisioned capacity.


        :param display_name: The display_name of this UpdateProvisionedCapacityDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UpdateProvisionedCapacityDetails.
        An optional description of the provisioned capacity.


        :return: The description of this UpdateProvisionedCapacityDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateProvisionedCapacityDetails.
        An optional description of the provisioned capacity.


        :param description: The description of this UpdateProvisionedCapacityDetails.
        :type: str
        """
        self._description = description

    @property
    def number_of_units(self):
        """
        Gets the number_of_units of this UpdateProvisionedCapacityDetails.
        Provisioned Capacity Unit corresponds to the amount of characters processed per minute.


        :return: The number_of_units of this UpdateProvisionedCapacityDetails.
        :rtype: int
        """
        return self._number_of_units

    @number_of_units.setter
    def number_of_units(self, number_of_units):
        """
        Sets the number_of_units of this UpdateProvisionedCapacityDetails.
        Provisioned Capacity Unit corresponds to the amount of characters processed per minute.


        :param number_of_units: The number_of_units of this UpdateProvisionedCapacityDetails.
        :type: int
        """
        self._number_of_units = number_of_units

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateProvisionedCapacityDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateProvisionedCapacityDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateProvisionedCapacityDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateProvisionedCapacityDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateProvisionedCapacityDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateProvisionedCapacityDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateProvisionedCapacityDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateProvisionedCapacityDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
