# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class KnowledgeBaseMetadataSummary(object):
    """
    Represents metadata about a field including its name, type, supported operations, and possible values.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new KnowledgeBaseMetadataSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this KnowledgeBaseMetadataSummary.
        :type name: str

        :param type:
            The value to assign to the type property of this KnowledgeBaseMetadataSummary.
        :type type: str

        :param operations:
            The value to assign to the operations property of this KnowledgeBaseMetadataSummary.
        :type operations: list[str]

        :param values:
            The value to assign to the values property of this KnowledgeBaseMetadataSummary.
        :type values: list[oci.generative_ai_agent_runtime.models.KnowledgeBaseMetadataValue]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this KnowledgeBaseMetadataSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this KnowledgeBaseMetadataSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this KnowledgeBaseMetadataSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'name': 'str',
            'type': 'str',
            'operations': 'list[str]',
            'values': 'list[KnowledgeBaseMetadataValue]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'name': 'name',
            'type': 'type',
            'operations': 'operations',
            'values': 'values',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._name = None
        self._type = None
        self._operations = None
        self._values = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this KnowledgeBaseMetadataSummary.
        The name of the field


        :return: The name of this KnowledgeBaseMetadataSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this KnowledgeBaseMetadataSummary.
        The name of the field


        :param name: The name of this KnowledgeBaseMetadataSummary.
        :type: str
        """
        self._name = name

    @property
    def type(self):
        """
        **[Required]** Gets the type of this KnowledgeBaseMetadataSummary.
        The data type of the field (e.g., \"array\", \"number\", \"string\")


        :return: The type of this KnowledgeBaseMetadataSummary.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this KnowledgeBaseMetadataSummary.
        The data type of the field (e.g., \"array\", \"number\", \"string\")


        :param type: The type of this KnowledgeBaseMetadataSummary.
        :type: str
        """
        self._type = type

    @property
    def operations(self):
        """
        **[Required]** Gets the operations of this KnowledgeBaseMetadataSummary.
        List of supported operations for this field (e.g., \"equals\", \"in\", \"contains\")


        :return: The operations of this KnowledgeBaseMetadataSummary.
        :rtype: list[str]
        """
        return self._operations

    @operations.setter
    def operations(self, operations):
        """
        Sets the operations of this KnowledgeBaseMetadataSummary.
        List of supported operations for this field (e.g., \"equals\", \"in\", \"contains\")


        :param operations: The operations of this KnowledgeBaseMetadataSummary.
        :type: list[str]
        """
        self._operations = operations

    @property
    def values(self):
        """
        **[Required]** Gets the values of this KnowledgeBaseMetadataSummary.
        List of metadata values available in the knowledge base along with the matching documents count.


        :return: The values of this KnowledgeBaseMetadataSummary.
        :rtype: list[oci.generative_ai_agent_runtime.models.KnowledgeBaseMetadataValue]
        """
        return self._values

    @values.setter
    def values(self, values):
        """
        Sets the values of this KnowledgeBaseMetadataSummary.
        List of metadata values available in the knowledge base along with the matching documents count.


        :param values: The values of this KnowledgeBaseMetadataSummary.
        :type: list[oci.generative_ai_agent_runtime.models.KnowledgeBaseMetadataValue]
        """
        self._values = values

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this KnowledgeBaseMetadataSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this KnowledgeBaseMetadataSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this KnowledgeBaseMetadataSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this KnowledgeBaseMetadataSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this KnowledgeBaseMetadataSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this KnowledgeBaseMetadataSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this KnowledgeBaseMetadataSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this KnowledgeBaseMetadataSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this KnowledgeBaseMetadataSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this KnowledgeBaseMetadataSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this KnowledgeBaseMetadataSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this KnowledgeBaseMetadataSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
