# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MetadataFilter(object):
    """
    Filter for retrieving specific metadata
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MetadataFilter object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param field_name:
            The value to assign to the field_name property of this MetadataFilter.
        :type field_name: str

        :param value:
            The value to assign to the value property of this MetadataFilter.
        :type value: str

        """
        self.swagger_types = {
            'field_name': 'str',
            'value': 'str'
        }
        self.attribute_map = {
            'field_name': 'fieldName',
            'value': 'value'
        }
        self._field_name = None
        self._value = None

    @property
    def field_name(self):
        """
        **[Required]** Gets the field_name of this MetadataFilter.
        The name of the field to filter on


        :return: The field_name of this MetadataFilter.
        :rtype: str
        """
        return self._field_name

    @field_name.setter
    def field_name(self, field_name):
        """
        Sets the field_name of this MetadataFilter.
        The name of the field to filter on


        :param field_name: The field_name of this MetadataFilter.
        :type: str
        """
        self._field_name = field_name

    @property
    def value(self):
        """
        **[Required]** Gets the value of this MetadataFilter.
        The value to filter for in the specified field


        :return: The value of this MetadataFilter.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this MetadataFilter.
        The value to filter for in the specified field


        :param value: The value of this MetadataFilter.
        :type: str
        """
        self._value = value

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
